<?php
/**
 * Template for displaying course meta quiz within the loop.
 *
 * @author        ThemeMove
 * @theme-since   2.7.9
 * @theme-version 2.7.9
 */

defined( 'ABSPATH' ) || exit();

$course = learn_press_get_course();

if ( ! $course || '1' !== Maxcoach::setting( 'course_archive_meta_lession_enable' ) ) {
	return;
}

$count_items = intval( $course->count_items( 'lp_lesson' ) );
?>
<div class="course-lesson">
	<span class="meta-icon far fa-file-alt"></span>
	<span class="meta-value">
		<?php
		echo esc_html( sprintf( _n( '%s Lesson', '%s Lessons', $count_items, 'maxcoach' ), number_format_i18n( $count_items ) ) );
		?>
	</span>
</div>
