<?php
/**
 * Template for displaying course meta duration within the loop.
 *
 * @author        ThemeMove
 * @theme-since   2.7.9
 * @theme-version 2.7.9
 */

defined( 'ABSPATH' ) || exit();

$course = learn_press_get_course();

if ( ! $course || '1' !== Maxcoach::setting( 'course_archive_meta_duration_enable' ) ) {
	return;
}
?>

<div class="course-duration">
	<span class="meta-icon far fa-clock"></span>
	<span class="meta-value">
		<?php echo learn_press_get_post_translated_duration( get_the_ID(), esc_html__( 'Lifetime access', 'maxcoach' ) ); ?>
	</span>
</div>

