<?php
/**
 * Template for displaying wrap start of archive course within the loop.
 *
 * This template can be overridden by copying it to yourtheme/learnpress/loop/course/loop-begin.php.
 *
 * @author   ThimPress
 * @package  Learnpress/Templates
 * @version  4.0.0
 */

defined( 'ABSPATH' ) || exit();

$lg_columns = Maxcoach::setting( 'course_archive_lg_columns', 3 );
$md_columns = Maxcoach::setting( 'course_archive_md_columns' );
$sm_columns = Maxcoach::setting( 'course_archive_sm_columns' );

$wrapper_classes = [
	'maxcoach-main-post',
	'maxcoach-grid-wrapper',
	'maxcoach-course',
	'maxcoach-animation-zoom-in',
	'has-col-lg-' . $lg_columns,
	'has-col-md-' . $md_columns,
	'has-col-sm-' . $sm_columns,
];
?>

<div <?php echo wp_kses_post( apply_filters( 'learn_press_course_loop_begin', 'data-layout="' . learn_press_get_courses_layout() . '"' ) ); ?>
	class="learn-press-courses <?php echo esc_attr( implode( ' ', $wrapper_classes ) ); ?>">
