<?php
/**
 * Template for displaying checkout form.
 *
 * This template can be overridden by copying it to yourtheme/learnpress/checkout/form.php.
 *
 * @author        ThimPress
 * @package       Learnpress/Templates
 * @version       4.0.4
 *
 * @theme-since   1.0.0
 * @theme-version 2.7.3
 */

defined( 'ABSPATH' ) || exit();

$checkout = LP()->checkout();
?>
<?php
if ( ! is_user_logged_in() ) {
	?>
	<div class="learn-press-message error">
		<?php esc_html_e( 'Please log in to enroll in the course!', 'maxcoach' ); ?>
	</div>
	<?php
}

learn_press_show_message();
?>

<form method="post" id="learn-press-checkout-form" name="learn-press-checkout-form"
      class="lp-checkout-form learn-press-checkout checkout<?php echo ! is_user_logged_in() ? " guest-checkout" : ""; ?>"
      tabindex="0"
      action="<?php echo esc_url_raw( learn_press_get_checkout_url() ); ?>" enctype="multipart/form-data">
	<?php
	if ( has_action( 'learn-press/before-checkout-form' ) ) {
		?>
		<div class="lp-checkout-form__before">
			<?php do_action( 'learn-press/before-checkout-form' ); ?>
		</div>
		<?php
	}

	do_action( 'learn-press/checkout-form' );

	if ( has_action( 'learn-press/after-checkout-form' ) ) {
		?>
		<div class="lp-checkout-form__after">
			<?php do_action( 'learn-press/after-checkout-form' ); ?>
		</div>
		<?php
	}

	wp_nonce_field( 'learn-press-checkout', 'learn-press-checkout-nonce', false );
	?>
</form>
