<?php
/**
 * WP Framework
 *
 * @package WP File Download
 * @author  Joomunited
 * @version 1.0
 */

namespace Joomunited\WP_File_Download\Admin\Fields;

use Joomunited\WPFramework\v1_0_6\Field;

defined('ABSPATH') || die();

/**
 * Class Savesettings
 */
class Savesettings extends Button
{
    /**
     *  Render <input> tag
     *
     * @param array $field Field to render
     * @param array $data  Full datas
     *
     * @return string
     */
    public function getfield($field, $data)
    {
        $attributes = $field['@attributes'];
        $html       = '<div class="wpfd_file_buttons">';
        $html .= '<button type="button" class="ju-button ju-link-button file-settings-hide">' . __('Close', 'wpfd') . '</button>';
        $html .= '<button type="button" class="ju-button ju-v3-button file-settings-save-hide">' . __('Save Settings & close', 'wpfd') . '</button>';
        if (!empty($attributes['type']) || (!empty($attributes['hidden']) && $attributes['hidden'] !== 'true')) {
            if (!empty($attributes['label']) && $attributes['label'] !== '' && !empty($attributes['name']) && $attributes['name'] !== '') {
                // phpcs:ignore WordPress.WP.I18n -- Allow non literal arg
                $html .= '<label class="ju-setting-label" for="' . $attributes['name'] . '">' . __($attributes['label'], Factory::getApplication()->getName()) . '</label>';
            }
        }
        if (!empty($attributes['help']) && $attributes['help'] !== '') {
            $html .= '<div class="ju-settings-toolbox">';
            $html .= '<p class="help-block">' . $attributes['help'] . '</p>';
            $html .= '</div>';
        }
        if (empty($attributes['hidden']) || (!empty($attributes['hidden']) && $attributes['hidden'] !== 'true')) {
            $html .= '<input';
        } else {
            $html .= '<hidden';
        }

        if (!empty($attributes)) {
            foreach ($attributes as $attribute => $value) {
                if (in_array($attribute, array('type', 'id', 'class', 'placeholder', 'name', 'value')) && isset($value)) {
                    if ($attribute === 'value') {
                        $html .= ' value="' . esc_html__('Save settings', 'wpfd') . '"';
                    } elseif ($attribute === 'type') {
                        $html .= ' type="submit"';
                    } else {
                        $html .= ' ' . $attribute . '="' . $value . '"';
                    }
                }
            }
        }
        $html .= ' />';

        $html .= '</div>';
//        if (!empty($attributes['type']) || (!empty($attributes['hidden']) && $attributes['hidden'] !== 'true')) {
//            $html .= '</div></div>';
//        }


        return $html;
    }
}
