<?php
defined( 'ABSPATH' ) || exit;

if ( ! class_exists( 'TM_Addon_Stripe_Payment' ) ) {
	class TM_Addon_Stripe_Payment extends LP_Addon {

		public $version = TM_ADDON_PAYMENT_VER;

		public $require_version = TM_ADDON_PAYMENT_REQUIRE_VER;

		/**
		 * @var string
		 */
		public $plugin_file = TM_ADDON_PAYMENT_FILE;

		public $id = 'stripe';

		public function __construct() {
			parent::__construct();
		}

		/**
		 * Define Constants.
		 */
		protected function _define_constants() {
			define( 'TM_ADDON_PAYMENT_PATH', dirname( TM_ADDON_PAYMENT_FILE ) );
			define( 'TM_ADDON_PAYMENT_INC', TM_ADDON_PAYMENT_PATH . '/inc/' );
			define( 'TM_ADDON_PAYMENT_URL', plugin_dir_url( TM_ADDON_PAYMENT_FILE ) );
			define( 'TM_ADDON_PAYMENT_TEMPLATE', TM_ADDON_PAYMENT_PATH . '/templates/' );
		}

		/**
		 * Include required core files used in admin and on the frontend.
		 *
		 * @since 3.0.0
		 */
		protected function _includes() {
			include_once TM_ADDON_PAYMENT_INC . 'class-gateway-stripe.php';
		}

		/**
		 * Init hooks.
		 */
		protected function _init_hooks() {
			// add payment gateway class
			add_filter( 'learn_press_payment_method', array( $this, 'add_payment' ) );
			add_filter( 'learn-press/payment-methods', array( $this, 'add_payment' ) );
			add_action( 'wp_enqueue_scripts', array( $this, 'enqueue_assets' ) );
		}

		/**
		 * Enqueue assets.
		 */
		public function enqueue_assets() {
			if ( learn_press_is_checkout() && LP()->settings->get( $this->id . '.enable' ) ) {
				$settings = LP()->settings();

				wp_enqueue_script( 'stripe', 'https://js.stripe.comv3/', '', '3.0', true );
				wp_enqueue_script( 'thememove-payment-stripe', $this->get_plugin_url( 'assets/js/stripe.js' ), array( 'stripe' ), TM_ADDON_PAYMENT_VER, true );
				wp_enqueue_style( 'thememove-payment-stripe', $this->get_plugin_url( 'assets/css/style.css' ), array(), TM_ADDON_PAYMENT_VER, 'all' );

				$test_publish_key = $settings->get( "{$this->id}.test_publish_key" );
				$live_publish_key = $settings->get( "{$this->id}.live_publish_key" );
				$publish_key      = $settings->get( "{$this->id}.test_mode" ) == 'yes' ? $test_publish_key : $live_publish_key;

				$data = array(
					'publish_key'   => $publish_key,
					'plugin_url'    => plugins_url( '', TM_ADDON_PAYMENT_FILE ),
					'button_verify' => esc_html__( 'Updating', 'thememove-payment' ),
					'error_verify'  => esc_html__( 'Unable to process this payment, please try again or use alternative method.', 'thememove-payment' ),
				);

				wp_localize_script( 'thememove-payment-stripe', '$thememovePayment', $data );
			}
		}

		/**
		 * Add Stripe to payment system.
		 *
		 * @param $methods
		 *
		 * @return mixed
		 */
		public function add_payment( $methods ) {
			$methods['stripe'] = 'TM_Gateway_Stripe';

			return $methods;
		}

		/**
		 * Plugin links.
		 *
		 * @return array
		 */
		public function plugin_links() {
			$links[] = '<a href="' . admin_url( 'admin.php?page=learn-press-settings&tab=payments&section=stripe' ) . '">' . esc_html__( 'Settings', 'thememove-payment' ) . '</a>';

			return $links;
		}
	}
}
