<?php
defined('ABSPATH') || die('No direct script access allowed!');
/**
 * Local media library
 *
 *
 * @link       https://themeforest.net/user/nouthemes/portfolio
 * @since      1.0.0
 *
 * @package    Cloudfiles_Wordpress_Media_Library_Folders_Cloud
 * @subpackage Cloudfiles_Wordpress_Media_Library_Folders_Cloud/includes/providers
 * @author     Nouthemes <nguyenvanqui89@gmail.com>
 */


class Cloudfiles_Wordpress_Media_Library_Folders_Cloud_Provider_Local extends Cloudfiles_Wordpress_Media_Library_Folders_Cloud_Provider_Base {


	public function __construct($args=[]) {
		$this->name = esc_html__( 'Media Library', 'cloudfiles-wordpress-media-library-folders-cloud' );
		$this->slug = CLOUDFILES_WORDPRESS_MEDIA_LIBRARY_FOLDERS_CLOUD_LOCAL;
		$this->taxonomy = CLOUDFILES_WORDPRESS_MEDIA_LIBRARY_FOLDERS_CLOUD_TANONOMY_NAME;
		parent::__construct($args);
	}

	public function is_setup(){
		return true;
	}
	
	public function init(){
		$uploads = wp_upload_dir();
		$this->client = new stdClass;
	
		$this->adapter = new \League\Flysystem\Cached\CachedAdapter(
		    new Cloudfiles_Wordpress_Media_Library_Folders_Cloud_Adapter_Local($uploads['basedir'] ),
		    new \League\Flysystem\Cached\Storage\Memory()
		);
		
		$this->filesystem = new Cloudfiles_Wordpress_Media_Library_System_Filesystem($this->adapter);
	}

    /**
     * Check folder exist
     *
     * @return boolean
     */
    public function folder_exists($id)
    {
        try {
            $term = get_term_by('id', $id, $this->taxonomy);
            $term_name = $term->name;
        } catch (Exception $e) {
            error_log($e->getMessage());
            return false;
        }
        return true;
    }

    public function create_folder($args){
    	$defaults = array (
	        'name' => '',
			'parent' => 0,
			'meta' => []
	    );
	    
	    $args = wp_parse_args( $args, $defaults );
	    
	    return $this->create_term($args);
	}

	public function upload(string $path, $contents){
		return false;
	}
}
