<?php
defined('ABSPATH') || die('No direct script access allowed!');
/**
 * Google drive
 *
 *
 * @link       https://themeforest.net/user/nouthemes/portfolio
 * @since      1.0.0
 *
 * @package    Cloudfiles_Wordpress_Media_Library_Folders_Cloud
 * @subpackage Cloudfiles_Wordpress_Media_Library_Folders_Cloud/includes/providers
 * @author     Nouthemes <nguyenvanqui89@gmail.com>
 */


class Cloudfiles_Wordpress_Media_Library_Folders_Cloud_Provider_Google_Drive extends Cloudfiles_Wordpress_Media_Library_Folders_Cloud_Provider_Base {

	private $client_id;
	private $client_secret;
	private $refresh_token;

	public function __construct($args=[])
	{
		$this->name = esc_html__( 'Google Drive', 'cloudfiles-wordpress-media-library-folders-cloud' );
		$this->slug = CLOUDFILES_WORDPRESS_MEDIA_LIBRARY_FOLDERS_CLOUD_GOOGLE_DRIVE;
		$this->taxonomy = CLOUDFILES_WORDPRESS_MEDIA_LIBRARY_FOLDERS_CLOUD_GOOGLE_DRIVE_TANONOMY_NAME;

		$this->client_id = get_option('google_drive_client_id');
		$this->client_secret = get_option('google_drive_client_secret');
		$this->refresh_token = get_option('google_drive_refresh_token');
		
		parent::__construct($args);
	}

	protected function set_root(){
		$this->root = 'root';
	}

	public function is_setup(){
		$enable = get_option('noucloudfiles_enable_google_drive', 'yes');
		if($enable == 'no'){
			return false;
		}

		if(!empty($this->client_id) && !empty($this->client_secret) && !empty($this->refresh_token)){
			return true;
		}
		return false;
	}
	
	public function init(){
		$this->client = new \Google_Client();
		$this->client->setClientId(get_option('google_drive_client_id'));
		$this->client->setClientSecret(get_option('google_drive_client_secret'));
		$this->client->refreshToken(get_option('google_drive_refresh_token'));
		$this->service = new \Google_Service_Drive($this->client);
	
		$this->adapter = new Cloudfiles_Wordpress_Media_Library_Folders_Cloud_Adapter_Google_Drive($this->service, $this->folder_id);
		
		$this->filesystem = new Cloudfiles_Wordpress_Media_Library_System_Filesystem($this->adapter, ['disable_asserts' => true]);
	}

	public function format_id_folder($id){
		if(strpos($id, '/') === false){
			return $id;
		}
		$arr = explode('/', $id);
		return end($arr);
	}

	public function get_shared_link($file, $settings=[]){
		$result = $this->adapter->getUrl($file['path']);
		if($result){
			return $result;
		}
		return false;
	}

	public function build_path_from_folder($folder, $new_name){
		$old_path = $folder['data']['path'];
		if(strpos($old_path, '/') !== false){
			$arr = explode('/', $old_path);
			$new_arr = [];
			array_pop($arr);
			foreach($arr as $folder_id){
				$f = $this->find_folder_by_id($folder_id);
				if($f){
					$new_arr[] = $f['text'];
				}
			}
			$new_path = join('/', $new_arr). '/'.$new_name;
			return $new_path;
		}
		return $new_name;
	}
}
