<?php
defined('ABSPATH') || die('No direct script access allowed!');
/**
 * Dropbox
 *
 *
 * @link       https://themeforest.net/user/nouthemes/portfolio
 * @since      1.0.0
 *
 * @package    Cloudfiles_Wordpress_Media_Library_Folders_Cloud
 * @subpackage Cloudfiles_Wordpress_Media_Library_Folders_Cloud/includes/providers
 * @author     Nouthemes <nguyenvanqui89@gmail.com>
 */

use Spatie\Dropbox\Client;
use Spatie\Dropbox\Exceptions\BadRequest;

class Cloudfiles_Wordpress_Media_Library_Folders_Cloud_Provider_Dropbox extends Cloudfiles_Wordpress_Media_Library_Folders_Cloud_Provider_Base {

	private $access_token;

	public function __construct($args=[])
	{
		$this->name = esc_html__( 'Dropbox', 'cloudfiles-wordpress-media-library-folders-cloud' );
		$this->slug = CLOUDFILES_WORDPRESS_MEDIA_LIBRARY_FOLDERS_CLOUD_DROPBOX;

		$this->access_token = get_option('dropbox_access_token');

		$this->taxonomy = CLOUDFILES_WORDPRESS_MEDIA_LIBRARY_FOLDERS_CLOUD_DROPBOX_TANONOMY_NAME;
		
		parent::__construct($args);
	}

	public function is_setup(){
		$enable = get_option('noucloudfiles_enable_dropbox', 'yes');
		if($enable == 'no'){
			return false;
		}
		if(!empty($this->access_token)){
			return true;
		}
		return false;
	}
	
	public function init(){
		$this->client = new Client($this->access_token);
		$this->adapter = new Cloudfiles_Wordpress_Media_Library_Folders_Cloud_Adapter_Dropbox($this->client);
		$this->filesystem = new Cloudfiles_Wordpress_Media_Library_System_Filesystem($this->adapter, ['disable_asserts' => true, 'case_sensitive' => false]);
	}

	public function get_shared_link($file, $settings=[]){
		$path = $file['path'];
		$settings_default = [
			"requested_visibility" => "public",
			"audience" => "public",
			"access" => "editor"
		];
		$settings = wp_parse_args( $settings, $settings_default );
		$url = false;
		try{
			$create = $this->adapter->createSharedLinkWithSettings($path, $settings);
			if(isset($create['url'])){
				$url = $create['url'];
			}
		} catch (Exception $e) {
			$settings['access'] = "viewer";
			try{
				$create = $this->adapter->createSharedLinkWithSettings($path, $settings);
				if(isset($create['url'])){
					$url = $create['url'];
				}
			} catch (Exception $e) {
				//created
				error_log($e->getMessage());
			}
		}

		$result = $this->adapter->listSharedLinks($path);
		if(isset($result[0]) && isset($result[0]['url'])){
			$url = $result[0]['url'];
		}

		if($url){
			$url = str_replace('dl=0', 'dl=1', $url);
		}

		return $url;
	}
}
