<?php
if ( ! defined( 'WPINC' ) ) {
	die;
}
/**
* 
*/
class Cloudfiles_Wordpress_Media_Library_Folders_Cloud_Provider_Base
{
	public $slug;
	public $name;
	public $client;
    protected $folder_id;
    protected $service;
    public $adapter;
    protected $root;
    public $filesystem;
	public $taxonomy;
	protected $active;
    
    public function __construct($args=[])
	{
		$this->active = get_option('nou_cloudfiles_wordpress_media_license_active', 0);
		
		$this->set_root();
		
		if($this->is_setup()){
			if(isset($args['folder_id']) && !empty($args['folder_id'])){
				$this->folder_id = $args['folder_id'];
			}else{
				$this->folder_id = $this->root;
			}
			$this->init();
		}
	}

	protected function set_root(){
		$this->root = '';
	}

	public function is_setup(){
		return false;
	}

	public function init(){}

	public function get_name(){
		return $this->name;
	}

	public function get_client(){
		return $this->client;
	}

	public function get_folder_id(){
		return $this->folder_id;
	}

	public function get_service(){
		return $this->service;
	}

	public function get_filesystem(){
		return $this->filesystem;
	}

	public function get_meta_data($dir){
		
		$defaults = array (
	        'taxonomy' => $this->taxonomy,
			'provider' => $this->slug,
			'type' => '',
			'name' => '',
			'dirname' => '',
			'basename' => '',
			'filename' => '',
			'path' => '',
			'link' => '',
			'size' => '',
			'bytes' => '',
			'mimetype' => '',
			'timestamp' => '',
			'extension' => ''
		);
		if(is_array($dir)){
			$meta_data = $dir;
		}else{
			try {
				$meta_data = $this->filesystem->getMetadata($dir);
			} catch (Exception $e) {
				error_log($e->getMessage());
				$meta_data = [];
			}
		}
		
		$meta_data = wp_parse_args( $meta_data, $defaults );
		return $meta_data;
	}

	public function get_child_node($parent){
		$dir = $parent->term_id;
		$data = [];
		$contents = $parent->children;
		if(!empty($contents)){
			foreach ($contents as $folder) {

				$folder_id = get_term_meta($folder->term_id, 'noucloudfiles_folder_id', true);
				if(empty($folder_id)){
					if($this->slug != CLOUDFILES_WORDPRESS_MEDIA_LIBRARY_FOLDERS_CLOUD_LOCAL){
						continue;
					}
				}

				$data[] = [
					'id' => $folder->term_id,
					'taxonomy' => $this->taxonomy,
					'provider' => $this->slug,
					'text' => $folder->name,
					'parent' => $dir,
					'type' => 'folder',
					'children' => $this->get_child_node($folder),
					'a_attr' => [
						'data-provider' => $this->slug,
						'data-count' => noucloudfiles_total_cat_post_count($folder->term_id, $this->taxonomy)
					]
				];
			}
		}
		return $data;
	}

	public function get_node(){
		$data = [
			'id' => $this->slug,
			'taxonomy' => $this->taxonomy,
			'provider' => $this->slug,
			'text' => $this->name,
			'type' => 'folder',
			'children' => []
		];
		
		$contents = noucloudfiles_term_tree_array($this->taxonomy, 0);
		if(!empty($contents)){
			foreach ($contents as $folder) {
				
				$folder_id = get_term_meta($folder->term_id, 'noucloudfiles_folder_id', true);
				if(empty($folder_id)){
					if($this->slug != CLOUDFILES_WORDPRESS_MEDIA_LIBRARY_FOLDERS_CLOUD_LOCAL){
						continue;
					}
				}

				$data['children'][] = [
					'id' => $folder->term_id,
					'taxonomy' => $this->taxonomy,
					'provider' => $this->slug,
					'text' => $folder->name,
					'parent' => $this->slug,
					'type' => 'folder',
					'children' => $this->get_child_node($folder),
					'a_attr' => [
						'data-provider' => $this->slug,
						'data-count' => noucloudfiles_total_cat_post_count($folder->term_id, $this->taxonomy)
					]
				];
			}
		}
		
		return $data;
	}

    /**
     * Check folder exist
     *
     * @return boolean
     */
    public function folder_exists($id){
        try {
            $file = $this->filesystem->has($id);
        } catch (Exception $e) {
            error_log($e->getMessage());
            return false;
        }
        return true;
	}

    public function create_folder($args){
    	$defaults = array (
	        'name' => '',
	        'parent' => 0,
			'meta' => []
	    );
	    $result = false;
	    $args = wp_parse_args( $args, $defaults );
	    $name = noucloudfiles_get_valid_term_name($args['name'], $args['parent'], $this->taxonomy);
		
		try{

			if($args['parent'] > 0){
				$parent_path = get_term_meta($args['parent'], 'noucloudfiles_folder_id', true);
				if($parent_path){
					$name = $parent_path.'/'.$name;
				}
			}
			
			$new_dir = $this->filesystem->createDir($name);
			$args['meta'] = [];
			$args['path'] = $name;
			$result = $this->create_term($args);
			do_action('noucloudfiles_created_cloud_folder', $this, $args, $result);

		} catch (Exception $e) {
			$this->filesystem->deleteDir($name);
			error_log($e->getMessage());
		}

		do_action('init_list_folder', $this);
		
		return $result;
	}

    public function create_term($args){
    	$defaults = array (
	        'name' => '',
	        'slug' => '',
			'parent' => 0,
			'meta' => []
	    );
	    
	    $args = wp_parse_args( $args, $defaults );

		$name = noucloudfiles_get_valid_term_name($args['name'], $args['parent'], $this->taxonomy);
		
		$term_new = false;
		
	    try {
	    	$term_new = wp_insert_term(
	        	$name, 
	        	$this->taxonomy, 
	        	array(
	        		'slug' => ($args['slug'] != '') ? sanitize_title($args['slug']) : sanitize_title($name),
	        		'parent' => $args['parent']
	        	)
			);
			
			if( !is_wp_error($term_new) ){
				$term_new['name'] = $name;
			
				if(isset($args['meta']) && isset($args['meta']['path'])){
					add_term_meta($term_new["term_id"], 'noucloudfiles_folder_id', $args['meta']['path']);
				}
				add_term_meta($term_new["term_id"], 'noucloudfiles_folder_info', $args);
				add_term_meta($term_new["term_id"], 'noucloudfiles_folder_position', 10000);
				add_term_meta($term_new["term_id"], 'noucloudfiles_author', get_current_user_id());
			}else{
				$term_new = false;
			}

	    } catch (Exception $e) {
	    	error_log($e->getMessage());
		}
		
	    return $term_new;
    }

    public function sync_html(){
    	?>
    	<button type="button" data-sync="full" data-taxonomy="<?php echo esc_attr($this->taxonomy);?>" data-provider="<?php echo esc_attr($this->slug);?>" class="synchronization uk-button uk-button-primary uk-button-small"><?php echo esc_html__('Run full synchronization', 'cloudfiles-wordpress-media-library-folders-cloud');?></button>
		<p class="no-margin"><?php echo esc_html__('Or', 'cloudfiles-wordpress-media-library-folders-cloud');?></p>
    	<button type="button" data-sync="custom" data-taxonomy="<?php echo esc_attr($this->taxonomy);?>" data-provider="<?php echo esc_attr($this->slug);?>" class="custom-synchronization uk-button uk-button-secondary uk-button-small"><?php echo esc_html__('Choose folders you want', 'cloudfiles-wordpress-media-library-folders-cloud'); ?></button>
    	<div class="uk-margin js-folder" id="toggle_<?php echo esc_attr($this->slug);?>">
    		<ul class="menu"></ul>
    	</div>
    	<button id="run_synchronization_<?php echo esc_attr($this->slug);?>" type="button" data-sync="run-custom" data-taxonomy="<?php echo esc_attr($this->taxonomy);?>" data-provider="<?php echo esc_attr($this->slug);?>" class="synchronization uk-button uk-button-danger uk-button-small uk-margin-small-bottom run-synchronization hidden"><?php echo esc_html__('Run synchronization', 'cloudfiles-wordpress-media-library-folders-cloud');?></button>
    	<?php	
    }
	
	public function format_id_folder($id){
		return $id;
	}
	
	public function get_child_folder($dir){
		$data = [];
		$contents = $this->filesystem->listContents($dir);
		if(!empty($contents)){
			foreach ($contents as $folder) {
				$folder = noucloudfiles_prepare_data_adapter($this->slug, $folder);
				if($folder['type'] == 'dir'){
					$data[] = [
						'id' => $this->format_id_folder($folder['path']),
						'provider' => $this->slug,
						'text' => $folder['filename'],
						'parent' => $dir,
						'type' => 'folder',
						'children' => $this->get_child_folder($folder['path']),
						'data' => $folder
					];
				}
			}
		}
		return $data;
	}

	public function folders_tree_to_flat_array($array)
	{
		return noucloudfiles_folders_tree_to_flat_array($array);
	}

	public function find_folder_by_id($id){
		$folder_list = get_option('noucloudfiles_folder_list_'.$this->slug);
		$haystack = $this->folders_tree_to_flat_array($folder_list['children']);
		$folder = false;
		foreach ($haystack as $key => $value) {
			if ($value['id'] == $id) {
				$folder = $value;
				break;
			}
		}
		return $folder;
	}

	public function get_folder_cloud($dir='', $include_children=true, $clear_cache=false){

		if(!$this->is_setup() || is_null($this->filesystem)){
			if(isset($_GET['tab']) && $_GET['tab'] == $this->slug){
				Cloudfiles_Wordpress_Media_Library_Folders_Cloud_Admin_Settings::remove_error();
				Cloudfiles_Wordpress_Media_Library_Folders_Cloud_Admin_Settings::remove_message();
				Cloudfiles_Wordpress_Media_Library_Folders_Cloud_Admin_Settings::add_error( esc_html__('Please, authorize account.', 'cloudfiles-wordpress-media-library-folders-cloud') );
			}
			return [
				'id' => $this->slug,
				'provider' => $this->slug,
				'text' => $this->name,
				'type' => 'folder',
				'children' => []
			];
		}

		$key = '_cache_folder_list_'.wp_hash($this->slug.$dir.($include_children ? 1 : 0), 'nonce');

		if($clear_cache){
			delete_transient( $key );
		}

		if ( false === ( $data = get_transient( $key ) ) ) {
			
			$data = [
				'id' => $this->slug,
				'provider' => $this->slug,
				'text' => $this->name,
				'type' => 'folder',
				'children' => []
			];
			try{
				$contents = $this->filesystem->listContents($dir);
				if(!empty($contents)){
					foreach ($contents as $folder) {
						$folder = noucloudfiles_prepare_data_adapter($this->slug, $folder);
						if($folder['type'] == 'dir'){
							$data['children'][] = [
								'id' => $this->format_id_folder($folder['path']),
								'provider' => $this->slug,
								'text' => $folder['filename'],
								'parent' => $this->slug,
								'type' => 'folder',
								'children' => $include_children ? $this->get_child_folder($folder['path']) : [],
								'data' => $folder
							];
						}
					}
				}
			} catch (Exception $ex) {
				return new WP_Error('broke', esc_html__('Error communicating API: ') . $ex->getMessage());
			}

			set_transient( $key, $data, 60*5 );

			if($dir == '' && $include_children){
				update_option('noucloudfiles_folder_list_'.$this->slug, $data);
			}
		}
		
		return $data;
	}

	public function get_shared_link($file, $settings=[]){
		return false;
	}

	public function create_attachment($file, $folder, $term, $args){
		$file = noucloudfiles_prepare_data_adapter($this->slug, $file);
		
		$attachment = array(
			'post_mime_type' => $file['mimetype'],
			'post_title'     => $file['filename'],
			'post_content'   => '',
			'post_type'     => 'attachment',
			'post_status'    => 'inherit'
		);

		$public_url = $this->get_shared_link($file);
		if(!$public_url){
			return false;
		}

		$upload_path = wp_upload_dir();
		$args = wp_parse_args( $args, $attachment );
		$attach_id = wp_insert_post($args);

		$attached = trim($upload_path['subdir'], '/') . '/' . sanitize_title($file['filename']).'.'.$file['extension'];

		wp_set_object_terms((int) $attach_id, (int) $term['term_id'], $this->taxonomy);

		update_post_meta($attach_id, '_wp_attached_file', $attached);
		update_post_meta($attach_id, 'noucloudfiles_size', $file['size']);
		update_post_meta($attach_id, 'noucloudfiles_order', 0);
		update_post_meta($attach_id, 'noucloudfiles_file_info', $file);
		update_post_meta($attach_id, 'noucloudfiles_folder_info', $folder);
		update_post_meta($attach_id, 'noucloudfiles_file_id', $this->format_id_folder($file['path']));
		update_post_meta($attach_id, 'noucloudfiles_provider_id', $this->slug);
		update_post_meta($attach_id, 'noucloudfiles_author', get_current_user_id());
		update_post_meta($attach_id, 'noucloudfiles_file_url', $public_url);

		$urls = [];
		$uploaded_urls = [];
		$uploaded_urls[basename($attached)] = $public_url;
		$urls[$this->slug] = $uploaded_urls;
		update_post_meta( $attach_id, 'noucloudfiles_file_urls', $urls );

		$meta = array();
		if (strpos($file['mimetype'], 'image') !== false) {
			$meta['file'] = $attached;
			try {
				$stream = $this->filesystem->readStream($file['path']);
				$contents = stream_get_contents($stream);
				$putStream = tmpfile();
				fwrite($putStream, $contents);
				$path = stream_get_meta_data($putStream)['uri'];
				list($width, $height) = getimagesize($path);
				$meta['width'] = $width;
				$meta['height'] = $height;
				fclose($stream);
			} catch( Exception $e){
				//
				error_log($e->getMessage());
			}
		}

		if (isset($file['size'])) {
			$meta['filesize'] = $file['size'];
		}

		update_post_meta($attach_id, '_wp_attachment_metadata', $meta);

		return true;
	}

	public function build_path_from_folder($folder, $new_name){
		$old_path = $folder['data']['path'];
		if(strpos($old_path, '/') !== false){
			$arr = array_pop(explode('/', $old_path));
			$new_path = join('/', $arr). '/'.$new_name;
			return $new_path;
		}
		return $new_name;
	}

	public function rename_folder($args){
		$default = array(
			'provider' 		=> '', // provider
			'text' 			=> '', // old name
			'new_name'     	=> '', // new name
			'id'   			=> '' // term id
		);

		$args = wp_parse_args( $args, $default );

		// update term name
		$update = wp_update_term((int) $args['id'], $this->taxonomy, array('name' => $args['new_name']));
		if ( is_wp_error( $update ) ) {
			return false;
		}

		do_action('noucloudfiles_rename_folder', $this, $args);

		do_action('init_list_folder', $this);

		return true;
	}

	private function delete_term_by_id($term_id){

		$terms = get_terms( $this->taxonomy, array( 'fields' => 'ids', 'hide_empty' => false, 'parent' => $term_id ) );
		if ( ! empty( $terms ) && ! is_wp_error( $terms ) ){
			foreach ( $terms as $value ) {
				$this->delete_term_by_id($value);

				delete_term_meta( $value, 'noucloudfiles_folder_id');
				delete_term_meta( $value, 'noucloudfiles_folder_info');
				delete_term_meta( $value, 'noucloudfiles_folder_position');
				wp_delete_term( $value, $this->taxonomy );
			}
		}

		delete_term_meta( $term_id, 'noucloudfiles_folder_id');
		delete_term_meta( $term_id, 'noucloudfiles_folder_info');
		delete_term_meta( $term_id, 'noucloudfiles_folder_position');
		wp_delete_term( $term_id, $this->taxonomy );
	}

	public function delete_folder($args){
		$default = array(
			'id' => '' // term id
		);

		$args = wp_parse_args( $args, $default );

		try{
			$this->delete_term_by_id($args['id']);
			return true;
		} catch(Exception $e){
			//
			error_log($e->getMessage());
			return false;
		}
	}

	public function move_file_to_folder($args){
		$default = array(
			'post_id' => '',
			'term_id' => ''
		);

		$args = wp_parse_args( $args, $default );

		if($args['post_id'] != ''){
			$postIds = explode(',', $args['post_id']);
			try{
				foreach($postIds as $id){
					if($id > 0){
						wp_set_object_terms((int) $id, (int) $args['term_id'], $this->taxonomy);

						/**
						 * Set attachmnent folder after move file to folder
						 *
						 * @param integer Attachment ID
						 * @param integer Target folder
						 * @param array   Extra informations
						 *
						 * @ignore Hook already documented
						 */
						$data = [
							'trigger' => 'move_file',
							'provider' => $this->slug,
							'taxonomy' => $this->taxonomy,
							'term_id' => $args['term_id']
						];
						do_action('noucloudfiles_attachment_set_folder', $id, $args['term_id'], $data);

					}
				}
				return true;
			} catch(Exception $e){
				//
				error_log($e->getMessage());
				return false;
			}
		}
		return false;
	}

	public function clone_term($term_old, $args)
	{
		$term_new = wp_insert_term(
			$term_old->name, 
			$this->taxonomy, 
			array(
				'slug' => sanitize_title($term_old->name),
				'parent' => $args['parent']
			)
		);
		if( !is_wp_error($term_new) ){
			$args = array(
				'post_type' 		=> 'attachment',
				'posts_per_page' 	=> -1,
				'post_status' 		=> 'any',
				''.$this->taxonomy 	=> $term_old->slug
			);
			
			foreach ( noucloudfiles_lazy_loop( new WP_Query($args) ) as $post ) {
				$attach_id = get_the_ID();
				wp_set_object_terms((int) $attach_id, (int) $term_new['term_id'], $this->taxonomy);
			}

			try {
				$terms = get_terms( array(
					'taxonomy' => $this->taxonomy,
					'hide_empty' => false,
					'parent' => $term_old->term_id
				) );
	
				if( !empty($terms) ){
					foreach($terms as $term){
						$this->clone_term($term, $args);
					}
				}
			} catch (\Throwable $th) {
				error_log($th->getMessage());
			}

			return true;
		}

		return false;
	}

	public function copy_node($args){
		$default = array(
			'parent' => '',
			'old_parent' => '',
			'id' => '' // term_id
		);

		$args = wp_parse_args( $args, $default );

		$term_old = get_term_by('id', $args["id"], $this->taxonomy);
		if($term_old){
			try {
				$results = $this->clone_term($term_old, $args);
				if($results){
					do_action('noucloudfiles_copy_node', $this, $args);

					do_action('init_list_folder', $this);
				}
				return $results;
			} catch (\Throwable $th) {
				error_log($th->getMessage());
				return true;
			}
		}

		return false;
	}

	public function move_node($args){
		$default = array(
			'parent' => '',
			'old_parent' => '',
			'id' => '' // term_id
		);

		$args = wp_parse_args( $args, $default );
		
		$parent = $args["parent"] == $this->slug ? 0 : $args["parent"];

		try {
			wp_update_term($args["id"], $this->taxonomy, ['parent' => $parent]);

			do_action('noucloudfiles_move_node', $this, $args);

			do_action('init_list_folder', $this);

			return true;
		} catch (\Throwable $th) {
			error_log($th->getMessage());
			return true;
		}

	}

	public function upload(string $path, $contents){
		try {
			if($this->filesystem->has($path)){
				return $this->filesystem->update($path, $contents);
			}else{
				return $this->filesystem->write($path, $contents);
			}
		} catch( Exception $e){
			//
			error_log($e->getMessage());
		}
	}
}
?>