<?php
defined('ABSPATH') || die('No direct script access allowed!');
/**
 * AWS S3
 *
 *
 * @link       https://themeforest.net/user/nouthemes/portfolio
 * @since      1.0.0
 *
 * @package    Cloudfiles_Wordpress_Media_Library_Folders_Cloud
 * @subpackage Cloudfiles_Wordpress_Media_Library_Folders_Cloud/includes/providers
 * @author     Nouthemes <nguyenvanqui89@gmail.com>
 */

use Aws\S3\S3Client;
use League\Flysystem\Config;

class Cloudfiles_Wordpress_Media_Library_Folders_Cloud_Provider_Aws extends Cloudfiles_Wordpress_Media_Library_Folders_Cloud_Provider_Base {

	private $access_token;
	private $secret_access_token;
	private $bucket;
	private $region;
	private $path;

	public function __construct($args=[])
	{
		$this->name 				= esc_html__( 'AWS S3', 'cloudfiles-wordpress-media-library-folders-cloud' );
		$this->slug 				= CLOUDFILES_WORDPRESS_MEDIA_LIBRARY_FOLDERS_CLOUD_AWS;

		$this->access_token 		= get_option('aws_access_token');
		$this->secret_access_token 	= get_option('aws_secret_access_token');
		$this->path 				= get_option('aws_path', '');
		$this->bucket 				= get_option('aws_bucket');
		$this->region 				= get_option('aws_region');

		$this->taxonomy 			= CLOUDFILES_WORDPRESS_MEDIA_LIBRARY_FOLDERS_CLOUD_AWS_TANONOMY_NAME;
		
		parent::__construct($args);
	}

	public function is_setup(){
		$enable = get_option('noucloudfiles_enable_aws', 'yes');
		if($enable == 'no'){
			return false;
		}

		if(!empty($this->access_token) && !empty($this->secret_access_token) && !empty($this->bucket) && !empty($this->region)){
			return true;
		}
		return false;
    }
	
	public function init(){
		$this->client = new S3Client([
            'credentials' => [
                'key'    => $this->access_token,
                'secret' => $this->secret_access_token,
            ],
            'region' => $this->region,
            'version' => 'latest',
        ]);

		$this->adapter = new Cloudfiles_Wordpress_Media_Library_Folders_Cloud_Adapter_Aws($this->client, $this->bucket, $this->path);
		$this->filesystem = new Cloudfiles_Wordpress_Media_Library_System_Filesystem($this->adapter, new Config(['disable_asserts' => true, 'visibility' => 'public']));
	}

	public function get_base_url( $Keyname ) {
        try{
            $result = $this->client->putObject( array(
                'Bucket'     => $this->bucket,
                'Key'        => $Keyname,
                'Body'   => 'Cloudfiles -> getting the base url',
                'ACL'    => 'public-read'
            ) );

            if ( ! $result ) {
                error_log( print_r( 'Error when uploading get_base_url', true ) );
                $base_url = false;
            }
            else
				$base_url = str_replace( "/" .$Keyname , "", $result[ 'ObjectURL' ] );
				
				try{
					$this->client->deleteObject( array(
						'Bucket' => $this->bucket,
						'Key'    => $Keyname
					) );
				} catch(Exception $e){
					//
				}

            return $base_url;
        } catch(Exception $e){
            return false;
        }

	}
	
    public function get_shared_link($file, $settings=[]){
		$base_url = get_option('aws_base_url');
		
		if(empty($base_url)){
			$Keyname = uniqid() . '_nou_cloudfiles_' . uniqid() . '.txt';
            $base_url = $this->get_base_url( $Keyname );
            if(!empty($base_url)){
                update_option('aws_base_url', $base_url);
            }
		}

        $result = false;
        if(!empty($file['path']) && !empty($base_url)){
            $result = $base_url. '/' .$file['path'];
        }
        return $result;
    }
}
