<?php

if ( ! defined( 'ABSPATH' ) ) {
	exit; // Exit if accessed directly.
}

/**
 * Embed shortcode.
 *
 * @since      1.0.0
 * @package    Cloudfiles_Wordpress_Media_Library_Folders_Cloud
 * @subpackage Cloudfiles_Wordpress_Media_Library_Folders_Cloud/includes/elementor
 * @author     Nouthemes <nguyenvanqui89@gmail.com>
 */
class Cloudfiles_Wordpress_Media_Library_Folders_Cloud_Elementor_Embed extends \Elementor\Widget_Base {

	/**
	 * Get widget name.
	 *
	 * Retrieve image box widget name.
	 *
	 * @since 1.0.0
	 * @access public
	 *
	 * @return string Widget name.
	 */
	public function get_name() {
		return 'cloudfiles-embed';
	}

	/**
	 * Get widget title.
	 *
	 * Retrieve image box widget title.
	 *
	 * @since 1.0.0
	 * @access public
	 *
	 * @return string Widget title.
	 */
	public function get_title() {
		return esc_html__('Cloudfiles - Document Embedder', 'cloudfiles-wordpress-media-library-folders-cloud');
	}

	/**
	 * Get widget icon.
	 *
	 * Retrieve image box widget icon.
	 *
	 * @since 1.0.0
	 * @access public
	 *
	 * @return string Widget icon.
	 */
	public function get_icon() {
		return 'fa fa-code';
	}

	public function get_categories() {
		return [ 'basic' ];
	}

	/**
	 * Get widget keywords.
	 *
	 * Retrieve the list of keywords the widget belongs to.
	 *
	 * @since 2.1.0
	 * @access public
	 *
	 * @return array Widget keywords.
	 */
	public function get_keywords() {
		return [ 'embed', 'document' ];
	}

	/**
	 * Register image box widget controls.
	 *
	 * Adds different input fields to allow the user to change and customize the widget settings.
	 *
	 * @since 1.0.0
	 * @access protected
	 */
	protected function _register_controls() {
		$this->start_controls_section(
			'section_image',
			[
				'label' => esc_html__('Document Embedder', 'cloudfiles-wordpress-media-library-folders-cloud'),
			]
		);

		$this->add_control(
			'url',
			[
				'label' => __( 'URL document', 'cloudfiles-wordpress-media-library-folders-cloud' ),
				'type' => \Elementor\Controls_Manager::MEDIA,
				'default' => [
					'url' => '',
				],
			]
		);

		$this->add_control(
			'width',
			[
				'label' => __( 'Width', 'cloudfiles-wordpress-media-library-folders-cloud' ),
				'type' => \Elementor\Controls_Manager::TEXT,
				'default' => '100%'
			]
		);

		$this->add_control(
			'height',
			[
				'label' => __( 'Height', 'cloudfiles-wordpress-media-library-folders-cloud' ),
				'type' => \Elementor\Controls_Manager::TEXT,
				'default' => '100%'
			]
		);

		$this->end_controls_section();
	}

	/**
	 * Render cloudfiles widget output on the frontend.
	 *
	 * Written in PHP and used to generate the final HTML.
	 *
	 * @since 1.0.0
	 * @access protected
	 */
	protected function render() {
		$settings = $this->get_settings_for_display();
		$url = "";
		$pdfID = 0;
		
		if(!empty($settings['url']['url'])){
			$url = $settings['url']['url'];
			$pdfID = $settings['url']['id'];
		}else{
			return '';
		}
		
		$url = noucloudfiles_build_embed_url($url, $pdfID);
		$width = !empty($settings['width']) ? $settings['width'] : '100%';
		$height = !empty($settings['height']) ? $settings['height'] : '100%';
		
		?>
		<iframe data-id="<?php echo esc_attr($pdfID);?>" class="noucloudfiles_embed_document" src="<?php echo esc_url($url);?>" style="width: <?php echo esc_attr($width);?> !important; height: <?php echo esc_attr($height);?> !important;" frameborder="0"></iframe>
		<?php
	}

    protected function _content_template() {}
}
