<?php

/**
 * The file that defines the core plugin class
 *
 * A class definition that includes attributes and functions used across both the
 * public-facing side of the site and the admin area.
 *
 * @link       https://themeforest.net/user/nouthemes/portfolio
 * @since      1.0.0
 *
 * @package    Cloudfiles_Wordpress_Media_Library_Folders_Cloud
 * @subpackage Cloudfiles_Wordpress_Media_Library_Folders_Cloud/includes
 */

/**
 * The core plugin class.
 *
 * This is used to define internationalization, admin-specific hooks, and
 * public-facing site hooks.
 *
 * Also maintains the unique identifier of this plugin as well as the current
 * version of the plugin.
 *
 * @since      1.0.0
 * @package    Cloudfiles_Wordpress_Media_Library_Folders_Cloud
 * @subpackage Cloudfiles_Wordpress_Media_Library_Folders_Cloud/includes
 * @author     Nouthemes <nguyenvanqui89@gmail.com>
 */
class Cloudfiles_Wordpress_Media_Library_Folders_Cloud {

	/**
	 * The loader that's responsible for maintaining and registering all hooks that power
	 * the plugin.
	 *
	 * @since    1.0.0
	 * @access   protected
	 * @var      Cloudfiles_Wordpress_Media_Library_Folders_Cloud_Loader    $loader    Maintains and registers all hooks for the plugin.
	 */
	protected $loader;

	/**
	 * The unique identifier of this plugin.
	 *
	 * @since    1.0.0
	 * @access   protected
	 * @var      string    $plugin_name    The string used to uniquely identify this plugin.
	 */
	protected $plugin_name;

	/**
	 * The current version of the plugin.
	 *
	 * @since    1.0.0
	 * @access   protected
	 * @var      string    $version    The current version of the plugin.
	 */
	protected $version;
	private $active;

	/**
	 * Define the core functionality of the plugin.
	 *
	 * Set the plugin name and the plugin version that can be used throughout the plugin.
	 * Load the dependencies, define the locale, and set the hooks for the admin area and
	 * the public-facing side of the site.
	 *
	 * @since    1.0.0
	 */
	public function __construct() {

		$this->active = get_option('nou_cloudfiles_wordpress_media_license_active', 0);

		if ( defined( 'CLOUDFILES_WORDPRESS_MEDIA_LIBRARY_FOLDERS_CLOUD_VERSION' ) ) {
			$this->version = CLOUDFILES_WORDPRESS_MEDIA_LIBRARY_FOLDERS_CLOUD_VERSION;
		} else {
			$this->version = '1.0.0';
		}
		$this->plugin_name = 'cloudfiles-wordpress-media-library-folders-cloud';
		$this->autoloader();
		$this->load_dependencies();
		$this->set_locale();

		
		$this->include_vendor();
		$this->define_admin_hooks();
		$this->define_public_hooks();
		

		if($this->active == 1){
			$this->notice_first_use();

			if (is_plugin_active('elementor/elementor.php')) {
				// Register widgets
				add_action( 'elementor/widgets/widgets_registered', [ $this, 'register_widgets' ] );
			}
		}
	}

	/**
	* A static method that will setup the autoloader
	*
	* @static
	* @since  1.0
	* @access private
	*/
	private function autoloader() 
	{
		require_once plugin_dir_path( __FILE__ ) . 'class-cloudfiles-wordpress-media-library-folders-cloud-autoloader.php';
		// Core loader
		$core_autoloader = new Cloudfiles_Wordpress_Media_Library_Folders_Cloud_Autoloader();
		spl_autoload_register( array( $core_autoloader, 'load' ) );
	}

	/**
	 * Register all vendor
	 *
	 * @since    1.0.0
	 * @access   private
	 */
	public function include_vendor() {
		include_once( ABSPATH . 'wp-admin/includes/plugin.php' );
		include_once( ABSPATH . 'wp-includes/theme.php' );
		include_once( ABSPATH . 'wp-admin/includes/screen.php' );
		include_once CLOUDFILES_WORDPRESS_MEDIA_LIBRARY_FOLDERS_CLOUD_DIR . '/vendor/autoload.php';

		if($this->active == 1){
			Cloudfiles_Wordpress_Media_Library_Folders_Cloud_Taxonomy::init();
			Cloudfiles_Wordpress_Media_Library_Folders_Cloud_Ajax::init();
			Cloudfiles_Wordpress_Media_Library_Folders_Cloud_Media_Sorting::init();
			Cloudfiles_Wordpress_Media_Library_Folders_Cloud_Shortcodes::init();

			if (is_plugin_active('woocommerce/woocommerce.php')) {
				$woo = Cloudfiles_Wordpress_Media_Library_Folders_Cloud_Woocommerce::init();
			}
		}
	}

	/**
	 * Register Widgets
	 *
	 * Register new Elementor widgets.
	 *
	 * @since 1.2.0
	 * @access public
	 */
	public function register_widgets() {
		\Elementor\Plugin::instance()->widgets_manager->register_widget_type( new Cloudfiles_Wordpress_Media_Library_Folders_Cloud_Elementor_Embed() );
	}


	/**
	 * Load the required dependencies for this plugin.
	 *
	 * Include the following files that make up the plugin:
	 *
	 * - Cloudfiles_Wordpress_Media_Library_Folders_Cloud_Loader. Orchestrates the hooks of the plugin.
	 * - Cloudfiles_Wordpress_Media_Library_Folders_Cloud_i18n. Defines internationalization functionality.
	 * - Cloudfiles_Wordpress_Media_Library_Folders_Cloud_Admin. Defines all hooks for the admin area.
	 * - Cloudfiles_Wordpress_Media_Library_Folders_Cloud_Public. Defines all hooks for the public side of the site.
	 *
	 * Create an instance of the loader which will be used to register the hooks
	 * with WordPress.
	 *
	 * @since    1.0.0
	 * @access   private
	 */
	private function load_dependencies() {
		$this->loader = new Cloudfiles_Wordpress_Media_Library_Folders_Cloud_Loader();
	}

	/**
	 * Define the locale for this plugin for internationalization.
	 *
	 * Uses the Cloudfiles_Wordpress_Media_Library_Folders_Cloud_i18n class in order to set the domain and to register the hook
	 * with WordPress.
	 *
	 * @since    1.0.0
	 * @access   private
	 */
	private function set_locale() {

		$plugin_i18n = new Cloudfiles_Wordpress_Media_Library_Folders_Cloud_i18n();

		$this->loader->add_action( 'plugins_loaded', $plugin_i18n, 'load_plugin_textdomain' );

	}

	/**
	 * Register all of the hooks related to the admin area functionality
	 * of the plugin.
	 *
	 * @since    1.0.0
	 * @access   private
	 */
	private function define_admin_hooks() {

		$plugin_admin 		= new Cloudfiles_Wordpress_Media_Library_Folders_Cloud_Admin( $this->get_plugin_name(), $this->get_version() );
		$plugin_licenser 	= new Cloudfiles_Wordpress_Media_Library_Folders_Cloud_Licenser(CLOUDFILES_WORDPRESS_MEDIA_LIBRARY_FOLDERS_CLOUD_DIR_FILE, $this->plugin_name, $this->version );
		
		$this->loader->add_action( 'admin_notices', $plugin_licenser, 'show_admin_notices' );
		$this->loader->add_action( 'admin_menu', $plugin_admin, 'admin_menu' );
		$this->loader->add_action( 'admin_enqueue_scripts', $plugin_admin, 'enqueue_styles' );
		$this->loader->add_action( 'admin_enqueue_scripts', $plugin_admin, 'enqueue_scripts' );
		$this->loader->add_action( 'admin_init', $plugin_admin, 'admin_settings_init' );

		if($this->active == 1){
			$this->loader->add_action( 'admin_init', $plugin_admin, 'onedrive_authorize_redirect' );
			$this->loader->add_action( 'admin_init', $plugin_admin, 'handle_settings' );
			
			if (is_plugin_active('elementor/elementor.php')) {
				$this->loader->add_action(
					'elementor/editor/after_enqueue_scripts',
					$plugin_admin, 'enqueue_styles'
				);
				$this->loader->add_action(
					'elementor/editor/after_enqueue_scripts',
					$plugin_admin, 'enqueue_scripts'
				);
				$this->loader->add_action(
					'elementor/editor/footer',
					$plugin_admin, 'admin_media_manager'
				);

				$this->loader->add_action( 'pre_get_posts', $plugin_admin, 'elementor_pre_get_posts' );
			}


			$this->loader->add_action( 'admin_footer', $plugin_admin, 'admin_media_manager' );
			$this->loader->add_action( 'in_admin_footer', $plugin_admin, 'in_admin_footer' );
			$this->loader->add_action( 'restrict_manage_posts', $plugin_admin, 'add_folder_filter');
			$this->loader->add_action( 'init_list_folder', $plugin_admin, 'init_list_folder');
			$this->loader->add_action( 'post-plupload-upload-ui', $plugin_admin, 'post_plupload_upload_ui');
			$this->loader->add_action( 'add_attachment', $plugin_admin, 'after_upload', 0, 1);
			$this->loader->add_action( 'enqueue_block_editor_assets', $plugin_admin, 'gutenberg_enqueue_block_editor_assets');
			$this->loader->add_action( 'noucloudfiles_attachment_set_folder', $plugin_admin, 'copy_file_local_to_cloud', 10, 3);
			$this->loader->add_action( 'noucloudfiles_created_cloud_folder', $plugin_admin, 'created_cloud_folder', 10, 3);
		}

	}

	private function define_public_hooks(){
		if($this->active == 1){
			Cloudfiles_Wordpress_Media_Library_Folders_Cloud_Attachment_Filter::init();
		}
	}

	/**
	 * Run the loader to execute all of the hooks with WordPress.
	 *
	 * @since    1.0.0
	 */
	public function run() {
		$this->loader->run();
	}

	/**
	 * The name of the plugin used to uniquely identify it within the context of
	 * WordPress and to define internationalization functionality.
	 *
	 * @since     1.0.0
	 * @return    string    The name of the plugin.
	 */
	public function get_plugin_name() {
		return $this->plugin_name;
	}

	/**
	 * The reference to the class that orchestrates the hooks with the plugin.
	 *
	 * @since     1.0.0
	 * @return    Cloudfiles_Wordpress_Media_Library_Folders_Cloud_Loader    Orchestrates the hooks of the plugin.
	 */
	public function get_loader() {
		return $this->loader;
	}

	/**
	 * Retrieve the version number of the plugin.
	 *
	 * @since     1.0.0
	 * @return    string    The version number of the plugin.
	 */
	public function get_version() {
		return $this->version;
	}

    private function notice_first_use()
    {
        $count = noucloudfiles_count_folders();
        if (intval($count) > 0) {
            return;
        }
        add_action('admin_notices', function () {
            ?>
			<div class="noucloudfiles-first-use notice notice-info is-dismissible">
				<p>
					<strong><?php echo esc_html__('Cloudfiles', 'cloudfiles-wordpress-media-library-folders-cloud')?>: </strong>
					<?php echo esc_html__('Create your first folder for media library now.', 'cloudfiles-wordpress-media-library-folders-cloud')?>
					<a href="<?php echo esc_url(admin_url('/upload.php')) ?>">
						<?php echo esc_html__('Get Started', 'cloudfiles-wordpress-media-library-folders-cloud')?>
					</a>
				</p>
			</div>
			<?php
		});
    }

}
