<?php
if ( ! defined( 'ABSPATH' ) ) {
	exit; // Exit if accessed directly
}

/**
 * AJAX.
 *
 * AJAX Event Handler.
 *
 * @package    Cloudfiles_Wordpress_Media_Library_Folders_Cloud
 * @subpackage Cloudfiles_Wordpress_Media_Library_Folders_Cloud/includes
 * @since 1.0
 * @author nouthemes [nguyenvanqui89@gmail.com]
 */
class Cloudfiles_Wordpress_Media_Library_Folders_Cloud_Woocommerce
{

	public static function init() 
	{
		add_action('created_term', array(__CLASS__, 'created_term'), 10, 3);
		add_action('edited_term', array(__CLASS__, 'edited_term'), 10, 3);
		add_action('pre_delete_term', array(__CLASS__, 'pre_delete_term'), 10, 2);

		add_action( 'wp_insert_post', array(__CLASS__, 'wp_insert_post'), 10, 3 );
	}

	public static function wp_insert_post($post_ID, $post, $update)
	{
		if ( wp_is_post_revision( $post_ID ) )
			return;
		
		if($post->post_type == 'product'){
			$term_list = wp_get_post_terms( $post_ID, 'product_cat', array( 'fields' => 'ids' ) );
			if( !is_wp_error($term_list) ){
				foreach($term_list as $term_id){
					$folder = self::get_folder_from_product_cat($term_id);
					if($folder){
						$product           	= wc_get_product( $post_ID );
						$post_thumbnail_id 	= $product->get_image_id();
						if($post_thumbnail_id){
							self::remove_image_from_folder($post_thumbnail_id);
							wp_set_object_terms((int) $post_thumbnail_id, (int) $folder['term_id'], CLOUDFILES_WORDPRESS_MEDIA_LIBRARY_FOLDERS_CLOUD_TANONOMY_NAME);
						}

						$attachment_ids = $product->get_gallery_image_ids();
						if($attachment_ids){
							foreach($attachment_ids as $attach_id){
								self::remove_image_from_folder($attach_id);
								wp_set_object_terms((int) $attach_id, (int) $folder['term_id'], CLOUDFILES_WORDPRESS_MEDIA_LIBRARY_FOLDERS_CLOUD_TANONOMY_NAME);
							}
						}
					}
				}
			}
		}
	}

	public static function remove_image_from_folder($attach_id){
		$term_list = wp_get_post_terms( $attach_id, CLOUDFILES_WORDPRESS_MEDIA_LIBRARY_FOLDERS_CLOUD_TANONOMY_NAME, array( 'fields' => 'ids' ) );
		if( !is_wp_error($term_list) ){
			wp_remove_object_terms($attach_id, $term_list, CLOUDFILES_WORDPRESS_MEDIA_LIBRARY_FOLDERS_CLOUD_TANONOMY_NAME);
		}
	}

	public static function created_term($term_id, $tt_id, $taxonomy)
	{
		if($taxonomy == 'product_cat'){
			$category = get_term_by('id', $term_id, 'product_cat', ARRAY_A);
			if($category){
				$parent = 0;

				if($category['parent'] > 0){
					$folder_parent = self::get_folder_from_product_cat($category['parent']);
					if($folder_parent){
						$parent = $folder_parent['term_id'];
					}
				}

				$term_new = wp_insert_term(
					$category['name'], 
					CLOUDFILES_WORDPRESS_MEDIA_LIBRARY_FOLDERS_CLOUD_TANONOMY_NAME, 
					array(
						'slug' => $category['slug'],
						'parent' => $parent
					)
				);
			}
		}
	}

	public static function edited_term($term_id, $tt_id, $taxonomy)
	{
		// do something
		
	}

	public static function pre_delete_term($term_id, $taxonomy)
	{
		if($taxonomy == 'product_cat'){
			$folder = self::get_folder_from_product_cat($term_id);
			if($folder){
				wp_delete_term($folder['term_id'], CLOUDFILES_WORDPRESS_MEDIA_LIBRARY_FOLDERS_CLOUD_TANONOMY_NAME);
			}
		}
		
	}

	public static function get_folder_from_product_cat($woo_term_id){
		$category = get_term_by('id', $woo_term_id, 'product_cat', ARRAY_A);
		if(isset($category['slug'])){
			$folder = get_term_by('slug', $category['slug'], CLOUDFILES_WORDPRESS_MEDIA_LIBRARY_FOLDERS_CLOUD_TANONOMY_NAME, ARRAY_A);
			if(isset($folder['term_id'])){
				return $folder;
			}
		}
		return false;
	}

	public static function create_woocommerce_folder_root(){
		
		$category = get_term_by('slug', sanitize_title('Woocommerce'), CLOUDFILES_WORDPRESS_MEDIA_LIBRARY_FOLDERS_CLOUD_TANONOMY_NAME, ARRAY_A);
		if($category){
			return $category['term_id'];
		}

		$term_new = wp_insert_term(
			'Woocommerce', 
			CLOUDFILES_WORDPRESS_MEDIA_LIBRARY_FOLDERS_CLOUD_TANONOMY_NAME, 
			array(
				'slug' => sanitize_title('Woocommerce'),
				'parent' => 0
			)
		);

		if( !is_wp_error($term_new) ){
			return $term_new["term_id"];
		}

		return false;
	}

	public static function clone_category_to_folder(){
		$parent = self::create_woocommerce_folder_root();
		if($parent){
			$terms = get_terms( array(
				'taxonomy' => 'product_cat',
				'hide_empty' => false,
				'parent' => 0
			) );
			if( !empty($terms) ){
				foreach($terms as $term){
					// insert
					try {
						$term_new = get_term_by('slug', sanitize_title($term->name), CLOUDFILES_WORDPRESS_MEDIA_LIBRARY_FOLDERS_CLOUD_TANONOMY_NAME, ARRAY_A);
						if(!$term_new){
							$term_new = wp_insert_term(
								$term->name, 
								CLOUDFILES_WORDPRESS_MEDIA_LIBRARY_FOLDERS_CLOUD_TANONOMY_NAME, 
								array(
									'slug' => sanitize_title($term->name),
									'parent' => $parent
								)
							);
						}else{
							wp_update_term($term_new["term_id"], CLOUDFILES_WORDPRESS_MEDIA_LIBRARY_FOLDERS_CLOUD_TANONOMY_NAME, ['parent' => $parent]);
						}
						
						if( !is_wp_error($term_new) ){
							self::assign_post_to_folder(sanitize_title($term->name));
							self::clone_terms($term->term_id, $term_new["term_id"]);
						}
					} catch (\Throwable $th) {
						//
						error_log($th->getMessage());
					}

				}
			}
			
		}
		return false;
	}

	public static function clone_terms($woo_parent, $parent){
		$terms = get_terms( array(
			'taxonomy' => 'product_cat',
			'hide_empty' => false,
			'parent' => $woo_parent
		) );
		if( !empty($terms) ){
			foreach($terms as $term){
				// insert
				try {
					$term_new = get_term_by('slug', sanitize_title($term->name), CLOUDFILES_WORDPRESS_MEDIA_LIBRARY_FOLDERS_CLOUD_TANONOMY_NAME, ARRAY_A);
					if(!$term_new){
						$term_new = wp_insert_term(
							$term->name, 
							CLOUDFILES_WORDPRESS_MEDIA_LIBRARY_FOLDERS_CLOUD_TANONOMY_NAME, 
							array(
								'slug' => sanitize_title($term->name),
								'parent' => $parent
							)
						);
					}else{
						wp_update_term($term_new["term_id"], CLOUDFILES_WORDPRESS_MEDIA_LIBRARY_FOLDERS_CLOUD_TANONOMY_NAME, ['parent' => $parent]);
					}

					if( !is_wp_error($term_new) ){
						self::assign_post_to_folder(sanitize_title($term->name));
						self::clone_terms($term->term_id, $term_new["term_id"]);
					}
				} catch (\Throwable $th) {
					//
					error_log($th->getMessage());
				}

			}
		}
	}

	public static function assign_post_to_folder($slug){
		$term_new = get_term_by('slug', $slug, CLOUDFILES_WORDPRESS_MEDIA_LIBRARY_FOLDERS_CLOUD_TANONOMY_NAME, ARRAY_A);
		$term_id = $term_new['term_id'];

		$args = array(
			'post_type'             => 'product',
			'post_status'           => 'publish',
			'posts_per_page'        => -1,
			'product_cat'			=> $slug
		);
		
		foreach ( noucloudfiles_lazy_loop( new WP_Query($args) ) as $post ) {
			$product           	= wc_get_product( get_the_ID() );
			$post_thumbnail_id 	= $product->get_image_id();
			if($post_thumbnail_id){
				wp_set_object_terms((int) $post_thumbnail_id, (int) $term_id, CLOUDFILES_WORDPRESS_MEDIA_LIBRARY_FOLDERS_CLOUD_TANONOMY_NAME);
			}

			$attachment_ids = $product->get_gallery_image_ids();
			if($attachment_ids){
				foreach($attachment_ids as $attach_id){
					wp_set_object_terms((int) $attach_id, (int) $term_id, CLOUDFILES_WORDPRESS_MEDIA_LIBRARY_FOLDERS_CLOUD_TANONOMY_NAME);
				}
			}
		}
	}
}