<?php

/**
 * Walker Dropdown Filter
 *
 * @link       https://themeforest.net/user/nouthemes/portfolio
 * @since      1.0.0
 *
 * @package    Cloudfiles_Wordpress_Media_Library_Folders_Cloud
 * @subpackage Cloudfiles_Wordpress_Media_Library_Folders_Cloud/includes
 */

/**
 * Fired during plugin activation.
 *
 * This class defines all code necessary to run during the plugin's activation.
 *
 * @since      1.0.0
 * @package    Cloudfiles_Wordpress_Media_Library_Folders_Cloud
 * @subpackage Cloudfiles_Wordpress_Media_Library_Folders_Cloud/includes
 * @author     Nouthemes <nguyenvanqui89@gmail.com>
 */
class Cloudfiles_Wordpress_Media_Library_Folders_Cloud_Walker_Filter  extends Walker_CategoryDropdown
{

    public function start_el(&$output, $category, $depth = 0, $args = array(), $id = 0)
    {

        $pad = str_repeat('&nbsp;', $depth * 3);

        $cat_name = apply_filters('list_cats', $category->name, $category);

        $output .= ',{"term_id":"' . $category->term_id . '",';

        $output .= '"term_name":"' . $pad . esc_attr($cat_name);
        if ($args['show_count']) {
            $output .= '&nbsp;&nbsp;';
        }
        $output .= '"}';
    }

}
