<?php
if ( ! defined( 'ABSPATH' ) ) {
	exit; // Exit if accessed directly
}

/**
 * AJAX.
 *
 * AJAX Event Handler.
 *
 * @package    Cloudfiles_Wordpress_Media_Library_Folders_Cloud
 * @subpackage Cloudfiles_Wordpress_Media_Library_Folders_Cloud/includes
 * @since 1.0
 * @author nouthemes [nguyenvanqui89@gmail.com]
 */
class Cloudfiles_Wordpress_Media_Library_Folders_Cloud_Taxonomy 
{

	public static function init() 
	{
		add_action( 'admin_init', array(__CLASS__, 'register_taxonomy') );
	}

    public static function register_taxonomy()
    {
        foreach (CLOUDFILES_WORDPRESS_MEDIA_LIBRARY_FOLDERS_CLOUD_TANONOMIES as $tax) {
            $p = str_replace('noucloudfiles_tax_', '', $tax);
            $p = ($p == 'onedrive_b') ? CLOUDFILES_WORDPRESS_MEDIA_LIBRARY_FOLDERS_CLOUD_ONEDRIVE_BUSINESS : $p;
            $provider = new Cloudfiles_Wordpress_Media_Library_Folders_Cloud_Pro($p);
            try {
                $args = array(
                    "hierarchical" => true,
                    "labels" => array(
                        'name' => sprintf('%s %s', esc_html__('Folder', 'cloudfiles-wordpress-media-library-folders-cloud'), $provider->client->get_name()),
                        'singular_name' => sprintf('%s %s', esc_html__('Folder', 'cloudfiles-wordpress-media-library-folders-cloud'), $provider->client->get_name()),
                        'add_new_item' => esc_html__('Add New Folder', 'cloudfiles-wordpress-media-library-folders-cloud'),
                        'edit_item' => esc_html__('Edit Folder', 'cloudfiles-wordpress-media-library-folders-cloud'),
                        'new_item' => esc_html__('Add New Folder', 'cloudfiles-wordpress-media-library-folders-cloud'),
                        'search_items' => esc_html__('Search Folder', 'cloudfiles-wordpress-media-library-folders-cloud'),
                        'not_found' => esc_html__('Folder not found', 'cloudfiles-wordpress-media-library-folders-cloud'),
                        'not_found_in_trash' => esc_html__('Folder not found in trash', 'cloudfiles-wordpress-media-library-folders-cloud'),
                    ),
                    'show_ui' => true,
                    'show_in_menu' => false,
                    'show_in_nav_menus' => false,
                    'show_in_quick_edit' => false,
                    'update_count_callback' => '_update_generic_term_count',
                    'show_admin_column' => false,
                    "rewrite" => false
                );
                register_taxonomy($tax, "attachment", $args);
            } catch (\Throwable $th) {
                //throw $th;
                error_log($p.': '.$th->getMessage());
            }
        }
    }
}