<?php
if ( ! defined( 'WPINC' ) ) {
	die;
}

/**
 * Sync from cloud to local helper
 *
 * @link       https://themeforest.net/user/nouthemes/portfolio
 * @since      1.0.0
 *
 * @package    Cloudfiles_Wordpress_Media_Library_Folders_Cloud
 * @subpackage Cloudfiles_Wordpress_Media_Library_Folders_Cloud/includes
 */

class Cloudfiles_Wordpress_Media_Library_Folders_Cloud_Sync_Helper {

	public $provider;

	/**
	 * Constructor.
	 */
	public function __construct(Cloudfiles_Wordpress_Media_Library_Folders_Cloud_Pro $pro) {

		$this->provider = $pro->client;
	}

	public function get_folder_parent_id($folder){
		try{
			return noucloudfiles_get_term_id_by_folder_id($this->provider->taxonomy, $folder['data']['path']);
		} catch (Exception $e) {
			error_log($e->getMessage());
			return 0;
		}
	}

	public function folders_tree_to_flat_array($array){
		return noucloudfiles_folders_tree_to_flat_array($array);
	}

	public function get_folder_parent($folder, $list_folder){
		$parent_folder = false;
		$folder_id = $this->provider->format_id_folder($folder['parent']);
		$list_folder = $this->folders_tree_to_flat_array($list_folder);
		foreach($list_folder as $f){
			if($f['id'] == $folder_id){
				$parent_folder = $f;
				break;
			}
		}
		return $parent_folder;
	}

	public function create_attachment($file, $folder, $term, $args){
		return $this->provider->create_attachment($file, $folder, $term, $args);
	}

	public function do_sync_file($file, $folder, $term){
		$results = false;
		$file = noucloudfiles_prepare_data_adapter($this->provider->slug, $file);
		$query_args = array(
			'post_type' => 'attachment',
			'posts_per_page' => -1,
			'post_status' => 'any',
			'meta_query' => array(
				'relation' => 'AND', 
				array(
					'key'       => 'noucloudfiles_file_id',
					'value'     => $this->provider->format_id_folder($file['path']),
					'compare'   => '='
				),
				array(
					'key'       => 'noucloudfiles_provider_id',
					'value'     => $this->provider->slug,
					'compare'   => '='
				)
			)
		);

		$files = new WP_Query($query_args);
		if($files->have_posts()):
			//update file
			while ( $files->have_posts() ) : $files->the_post();
				$attach_id = get_the_ID();
				try {
					$public_url = $this->provider->get_shared_link($file);
					if($public_url){
						update_post_meta($attach_id, 'noucloudfiles_file_url', $public_url);
					}
				} catch (\Throwable $th) {}
				
				wp_set_object_terms((int) $attach_id, (int) $term['term_id'], $this->provider->taxonomy);
				$results = true;
			endwhile;
		else:
			//insert file
			$args = array(
				'post_mime_type' => $file['mimetype'],
				'post_title'     => $file['filename']
			);
			$results = $this->create_attachment($file, $folder, $term, $args);
		endif;
		// Reset Post Data
		wp_reset_postdata();

		return $results;
	}

	public function get_or_create_term($folder){
		$list_folder = get_option('noucloudfiles_folder_list_'.$this->provider->slug);
		$parent_folder = $this->get_folder_parent($folder, $list_folder['children']);
		
		$parent = 0;
		if($parent_folder){
			$parent = $this->get_folder_parent_id($parent_folder);
		}
		
		$args = array (
			'name' => $folder['text'],
			'slug' => sanitize_title($folder['id']),
			'parent' => $parent ? $parent : 0,
			'meta' => $this->provider->get_meta_data($folder['data'])
		);
		
		$term = get_term_by('slug', $args['slug'], $this->provider->taxonomy, ARRAY_A);
		if( !isset($term['term_id']) ){
			$term = $this->provider->create_term($args);
		}

		if( isset($term['term_id']) ){
			try {
				wp_update_term( 
					$term['term_id'], 
					$this->provider->taxonomy, 
					[
						'name' => $args['name'],
						'slug' => $args['slug']
					] 
				);
			} catch (\Throwable $th) {}

			try {
				update_term_meta( $term["term_id"], 'noucloudfiles_folder_id', $folder['data']['path'] );
				update_term_meta( $term["term_id"], 'noucloudfiles_folder_info', $folder );
			} catch (\Throwable $th) {
				//throw $th;
			}

			return $term;
		}

		return false;
	}

	public function do_sync_files_of_single_folder($term, $parent_folder){
		$contents = $this->provider->filesystem->listContents($parent_folder['data']['path']);
		if(!empty($contents)){
			foreach ($contents as $item) {
				$item = noucloudfiles_prepare_data_adapter($this->provider->slug, $item);
				if($item['type'] == 'dir'){
					$folder = [
						'id' => $this->provider->format_id_folder($item['path']),
						'provider' => $this->provider->slug,
						'text' => $item['filename'],
						'parent' => $parent_folder['id'],
						'type' => 'folder',
						'children' => [],
						'data' => $item
					];
					$new_term = $this->get_or_create_term($folder);
					if($new_term){
						$this->do_sync_files_of_single_folder($new_term, $folder);
					}
				}else{
					$this->do_sync_file($item, $parent_folder, $term);
				}
			}
		}
	}

	
	public function do_sync_parent_of_single_folder($term, $folder, $list_folder){
		$parent_folder = $this->get_folder_parent($folder, $list_folder);
		if($parent_folder){
			$parent_term = $this->get_or_create_term($parent_folder);
			if(isset($parent_term['term_id'])){
				wp_update_term( $term['term_id'], $this->provider->taxonomy, array('parent' => $parent_term['term_id']) );
				if(isset($parent_folder['parent']) && $parent_folder['parent'] != $parent_folder['provider']){
					$this->do_sync_parent_of_single_folder($parent_term, $parent_folder, $list_folder);
				}
			}
		}
	}

	public function do_sync_single_folder($folder, $list_folder){
		$term = $this->get_or_create_term($folder);
		if(isset($term['term_id'])){
			if(isset($folder['parent']) && $folder['parent'] != $folder['provider']){
				$this->do_sync_parent_of_single_folder($term, $folder, $list_folder);
			}
			$this->do_sync_files_of_single_folder($term, $folder);
			return true;
		}
		return false;
	}
	
	private function get_list_folder($folder, $flat_list_folder){
		$list_sync_folder = [];
		if(isset($folder['children']) && count($folder['children']) > 0){
			foreach($folder['children'] as $child_folder){
				$item = array_values(array_filter($flat_list_folder, function($e) use ($child_folder) {
					return $e['id'] == $child_folder['id'];
				}));
				
				if(is_array($item) && isset($item[0])){
					$list_sync_folder[] = $item[0];
				}

				if(isset($child_folder['children']) && count($child_folder['children']) > 0){
					$nested = $this->get_list_folder($child_folder, $flat_list_folder);
					if(count($nested) > 0){
						$list_sync_folder = array_merge($list_sync_folder, $nested);
					}
				}
			}
		}
		return $list_sync_folder;
	}

	public function do_sync_from_cloud_to_local($data_selected=[], $is_root=false){
		set_time_limit(0);
		$list_folder = get_option('noucloudfiles_folder_list_'.$this->provider->slug);
		$flat_list_folder = $this->folders_tree_to_flat_array($list_folder['children']);
		
		$list_sync_folder = [];
		foreach($data_selected as $folder){
			if($folder['id'] == $folder['provider']){
				$list_sync_folder = $flat_list_folder;
				break;
			}else{

				$item = array_values(array_filter($flat_list_folder, function($e) use ($folder) {
					return $e['id'] == $folder['id'];
				}));
				
				if(is_array($item) && isset($item[0])){
					$list_sync_folder[] = $item[0];
				}

				$nested = $this->get_list_folder($folder, $flat_list_folder);
				if(count($nested) > 0){
					$list_sync_folder = array_merge($list_sync_folder, $nested);
				}
			}
		}

		try {
			foreach($list_sync_folder as $folder){
				$this->do_sync_single_folder($folder, $list_folder['children']);
			}
			return true;
		} catch (\Throwable $th) {
			error_log($th->getMessage());
		}

		return false;
	}

}