<?php
/**
 * Shortcodes
 *
 * @since      1.0.0
 * @package    Cloudfiles_Wordpress_Media_Library_Folders_Cloud
 * @subpackage Cloudfiles_Wordpress_Media_Library_Folders_Cloud/includes
 * @author     Nouthemes <nguyenvanqui89@gmail.com>
 */
class Cloudfiles_Wordpress_Media_Library_Folders_Cloud_Shortcodes {

	public static function init() {
        $shortcodes = array(
			'noucloudfiles_embed_document' => __CLASS__ . '::embed_document'
		);

		foreach ( $shortcodes as $shortcode => $function ) {
			add_shortcode( $shortcode, $function );
        }
        
        // Gutenberg block
		if (function_exists('register_block_type')) {
			register_block_type( 'noucloudfiles/document-embedder-viewer', array(
				'render_callback' => array(__CLASS__, 'embed_document')
			) );
		}
    }
    
    public static function embed_document($atts, $content = null) {
        extract(shortcode_atts(array(
            'pdfID' => '',
            "url" => '',
            "width" => '100%',
            "height" => '100%'
        ), $atts));

        $url = noucloudfiles_build_embed_url($url, $pdfID);
        return '<iframe data-id="'.esc_attr($pdfID).'" class="noucloudfiles_embed_document" src="' . esc_url($url) . '" style="width:'.esc_attr($width).' !important; height:'.esc_attr($height).' !important;" frameborder="0"></iframe>';
    }

}
