<?php
if ( ! defined( 'ABSPATH' ) ) {
	exit; // Exit if accessed directly
}

/**
 * Main.
 *
 *
 * @package    Cloudfiles_Wordpress_Media_Library_Folders_Cloud
 * @subpackage Cloudfiles_Wordpress_Media_Library_Folders_Cloud/includes
 * @since 1.0
 * @author nouthemes [nguyenvanqui89@gmail.com]
 */
class Cloudfiles_Wordpress_Media_Library_Folders_Cloud_Pro
{

	public $provider;
	public $client;
	private $active;

	/**
	 * Constructor.
	 */
	public function __construct($provider) {
		$this->active = get_option('nou_cloudfiles_wordpress_media_license_active', 0);
		$this->provider = $provider;
		$this->set_client();
	}

	private function set_client(){
		
		if(!in_array($this->provider, CLOUDFILES_WORDPRESS_MEDIA_LIBRARY_FOLDERS_CLOUD_PROVIDERS)){
			return new WP_Error('broke', esc_html__('Provider not found.'));
		}

		switch ($this->provider) {
			case CLOUDFILES_WORDPRESS_MEDIA_LIBRARY_FOLDERS_CLOUD_GOOGLE_DRIVE:
				$this->client = new Cloudfiles_Wordpress_Media_Library_Folders_Cloud_Provider_Google_Drive();
				break;
			case CLOUDFILES_WORDPRESS_MEDIA_LIBRARY_FOLDERS_CLOUD_DROPBOX:
				$this->client = new Cloudfiles_Wordpress_Media_Library_Folders_Cloud_Provider_Dropbox();
				break;
			case CLOUDFILES_WORDPRESS_MEDIA_LIBRARY_FOLDERS_CLOUD_ONEDRIVE:
				$this->client = new Cloudfiles_Wordpress_Media_Library_Folders_Cloud_Provider_Onedrive();
				break;
			case CLOUDFILES_WORDPRESS_MEDIA_LIBRARY_FOLDERS_CLOUD_ONEDRIVE_BUSINESS:
				$this->client = new Cloudfiles_Wordpress_Media_Library_Folders_Cloud_Provider_Onedrive_Business();
				break;
			case CLOUDFILES_WORDPRESS_MEDIA_LIBRARY_FOLDERS_CLOUD_AWS:
				$this->client = new Cloudfiles_Wordpress_Media_Library_Folders_Cloud_Provider_Aws();
				break;
			default:
				$this->client = new Cloudfiles_Wordpress_Media_Library_Folders_Cloud_Provider_Local();
				break;
		}

		return $this->client;
	}

	public function is_enable(){
		
		if($this->active == 0){
			return false;
		}

		try {
			return $this->client->is_setup();
		} catch (\Throwable $th) {
			return false;
		}
	}

	public function get_node($args=[]){
		if(!$this->is_enable()){
			return false;
		}
		return $this->client->get_node($args);
	}

	public function get_folder_cloud($dir='', $include_children=true, $clear_cache=false){
		if(!$this->is_enable()){
			return false;
		}
		return $this->client->get_folder_cloud($dir, $include_children, $clear_cache);
	}

	public function rename_folder($args){
		return $this->client->rename_folder($args);
	}

	public function delete_folder($args){
		return $this->client->delete_folder($args);
	}

	public function move_file_to_folder($args){
		return $this->client->move_file_to_folder($args);
	}

	public function copy_node($args){
		return $this->client->copy_node($args);
	}

	public function move_node($args){
		return $this->client->move_node($args);
	}

	public function upload(string $path, $contents){
		return $this->client->upload($path, $contents);
	}
}