<?php
/**
 * Media sorting
 *
 * @since      1.0.0
 * @package    Cloudfiles_Wordpress_Media_Library_Folders_Cloud
 * @subpackage Cloudfiles_Wordpress_Media_Library_Folders_Cloud/includes
 * @author     Nouthemes <nguyenvanqui89@gmail.com>
 */
class Cloudfiles_Wordpress_Media_Library_Folders_Cloud_Media_Sorting {

	public static function init() 
	{
        add_filter( 'post_mime_types', array(__CLASS__, 'modify_post_mime_types'));
        add_action( 'pre_get_posts', array(__CLASS__, 'filter'), 0, 1);
	}

    /**
     * Query attachment by file type
     * Base on /wp-includes/class-wp-query.php
     *
     * @param object $query Params use to query attachment
     *
     * @return mixed $query
     */
    public static function filter($query)
    {
        $filetype = 'all';
        if (isset($_GET['attachment-filter'])) {
            $filetype = $_GET['attachment-filter'];
        }

        if (isset($_REQUEST['query']['post_mime_type'])) {
            $filetype = $_REQUEST['query']['post_mime_type'];
        }

        if (isset($filetype) && in_array($filetype, array('noucloudfiles-pdf', 'noucloudfiles-zip'))) {
            $filetypes = explode('-', $filetype);
            $filetype  = $filetypes[1];
            if ($filetype === 'zip') {
                $query->query_vars['post_mime_type'] = 'application/zip';
            }
            if ($filetype === 'pdf') {
                $query->query_vars['post_mime_type'] = 'application/pdf';
            }
        }

        foreach (CLOUDFILES_WORDPRESS_MEDIA_LIBRARY_FOLDERS_CLOUD_TANONOMIES as $tax) {
            $p = str_replace('noucloudfiles_tax_', '', $tax);
            $p = ($p == 'onedrive_b') ? CLOUDFILES_WORDPRESS_MEDIA_LIBRARY_FOLDERS_CLOUD_ONEDRIVE_BUSINESS : $p;
            $provider = new Cloudfiles_Wordpress_Media_Library_Folders_Cloud_Pro($p);
            if($provider->is_enable()){
                $folder = 0;

                if(isset($_REQUEST['query']['noucloudfiles_'. $p .'_folder']) && $_REQUEST['query']['noucloudfiles_'. $p .'_folder'] > 0){
                    $folder = (int) $_REQUEST['query']['noucloudfiles_'. $p .'_folder'];  
                }

                if(isset($_GET['noucloudfiles_'. $p .'_folder']) && $_GET['noucloudfiles_'. $p .'_folder'] > 0){
                    $folder = (int) $_GET['noucloudfiles_'. $p .'_folder'];  
                }
                if($folder > 0){
                    $tax_query = array(
                        'taxonomy' => $tax, 
                        'field' => 'id', 
                        'terms' => $folder,
                        'operator'=> 'IN' 
                    );
                    $query->tax_query->queries[] = $tax_query; 
                    $query->query_vars['tax_query'] = $query->tax_query->queries;
                }
            }
        }
        return $query;
    }

    /**
     * Add file type to Filetype filter
     *
     * @param array $post_mime_types List of post mime types.
     *
     * @return array $post_mime_types
     */
    public static function modify_post_mime_types($post_mime_types)
    {
        if (empty($post_mime_types['noucloudfiles-pdf'])) {
            $post_mime_types['noucloudfiles-pdf'] = array(esc_html__('PDF', 'cloudfiles-wordpress-media-library-folders-cloud'));
        }

        if (empty($post_mime_types['noucloudfiles-zip'])) {
            $post_mime_types['noucloudfiles-zip'] = array(esc_html__('Zip & archives', 'cloudfiles-wordpress-media-library-folders-cloud'));
        }

        return $post_mime_types;
    }

}
