<?php
/**
* Autoload class 
*
* @package includes/
* @author nouthemes [nouthemes@gmail.com]
*/
defined( 'ABSPATH' ) OR exit;

if( !class_exists('Cloudfiles_Wordpress_Media_Library_Folders_Cloud_Autoloader') ){


	class Cloudfiles_Wordpress_Media_Library_Folders_Cloud_Autoloader 
	{

		/**
		 * Autoloader load method. Load the class.
		 *
		 * @param $class_name
		 */
		public function load( $class_name ) 
		{

			if ( 0 === strpos( $class_name, 'Cloudfiles_Wordpress_Media_Library' ) ) {

				// String to lower
				$class_name = strtolower( $class_name );
				
				// Format file name
				$file_name = 'class-cloudfiles-wordpress-media-library-folders-cloud-' . str_ireplace( '_', '-', str_ireplace( 'Cloudfiles_Wordpress_Media_Library_Folders_Cloud_', '', $class_name ) ) . '.php';
				
				if ( 0 === strpos( $class_name, 'cloudfiles_wordpress_media_library_folders_cloud_admin' ) ) {
					$file_path = 'admin/';
				}elseif ( 0 === strpos( $class_name, 'cloudfiles_wordpress_media_library_folders_cloud_public' ) ) {
					$file_path = 'public/';
				}elseif ( 0 === strpos( $class_name, 'cloudfiles_wordpress_media_library_folders_cloud_provider' ) ) {
					$file_path = 'includes/providers/';
				}elseif ( 0 === strpos( $class_name, 'cloudfiles_wordpress_media_library_folders_cloud_adapter' ) ) {
					$file_path = 'includes/adapter/';
				}elseif ( 0 === strpos( $class_name, 'cloudfiles_wordpress_media_library_folders_cloud_client' ) ) {
					$file_path = 'includes/clients/';
				}elseif ( 0 === strpos( $class_name, 'cloudfiles_wordpress_media_library_system' ) ) {
					$file_path = 'includes/system/';
					$file_name = 'class-cloudfiles-wordpress-media-library-system-' . str_ireplace( '_', '-', str_ireplace( 'Cloudfiles_Wordpress_Media_Library_System_', '', $class_name ) ) . '.php';
				}elseif ( 0 === strpos( $class_name, 'cloudfiles_wordpress_media_library_folders_cloud_elementor' ) ) {
					$file_path = 'includes/elementor/';
				}else{
					$file_path = 'includes/';
				}

				// Append file name to clas path
				$file_path .= $file_name;
				
				// Check & load file
				if ( file_exists( CLOUDFILES_WORDPRESS_MEDIA_LIBRARY_FOLDERS_CLOUD_DIR. $file_path ) ) {
					require_once( CLOUDFILES_WORDPRESS_MEDIA_LIBRARY_FOLDERS_CLOUD_DIR. $file_path );
				}

			}

		}

	}

}