<?php
if ( ! defined( 'ABSPATH' ) ) {
	exit; // Exit if accessed directly
}

/**
 * AJAX.
 *
 * AJAX Event Handler.
 *
 * @package    Cloudfiles_Wordpress_Media_Library_Folders_Cloud
 * @subpackage Cloudfiles_Wordpress_Media_Library_Folders_Cloud/includes
 * @since 1.0
 * @author nouthemes [nguyenvanqui89@gmail.com]
 */
class Cloudfiles_Wordpress_Media_Library_Folders_Cloud_Ajax 
{

	/**
	 * Hook in ajax handlers.
	 */
	public static function init() 
	{
		self::add_ajax_events();
	}

	/**
	 * Hook in methods - uses WordPress ajax handlers (admin-ajax).
	 */
	public static function add_ajax_events() 
	{
		
		$ajax_events = array(
			'create_folder',
			'save_splitter',
			'get_folders',
			'create_authorize_url',
			'sync_folders',
			'dropdown_folder_media_library',
			'upload_file_to_folder'
		);

		foreach ( $ajax_events as $ajax_event ) {
			add_action( 'wp_ajax_noucloudfiles_' . $ajax_event, array( __CLASS__, $ajax_event ) );
		}
	}
	public static function upload_file_to_folder(){
		$nonce = $_REQUEST['_wpnonce'];
		if ( wp_verify_nonce( $nonce, 'noucloudfiles_params_nonce' ) && isset($_POST['provider']) ) {
			error_log(print_r($_REQUEST, true));
		}
	}
	public static function dropdown_folder_media_library(){
		$nonce = $_REQUEST['_wpnonce'];
		if ( wp_verify_nonce( $nonce, 'noucloudfiles_params_nonce' )) {
			ob_start();
				noucloudfiles_dropdown_folder_media();
			$html = ob_get_clean();
			$data = array(
				'status' => 'success',
        		'html' => $html
        	);
			wp_send_json_success($data);
			exit;
		}
		wp_send_json_error();
		exit;
	}
	public static function sync_folders(){
		$nonce = $_REQUEST['_wpnonce'];
		if ( wp_verify_nonce( $nonce, 'noucloudfiles_params_nonce' ) && isset($_POST['provider']) ) {
			$data_selected = isset($_POST['selected']) ? json_decode(html_entity_decode(stripslashes($_POST['selected'])), true) : [];
			$status = 'fail';
			$message = esc_html__('Synchronization has been failed. Please try again.', 'cloudfiles-wordpress-media-library-folders-cloud');

			$provider = new Cloudfiles_Wordpress_Media_Library_Folders_Cloud_Pro($_POST['provider']);
			if($provider->is_enable()){
				try{
					$sync = new Cloudfiles_Wordpress_Media_Library_Folders_Cloud_Sync_Helper($provider);
					$result = $sync->do_sync_from_cloud_to_local($data_selected);
					if($result){
						$status = 'success';
						$message = esc_html__('Synchronization completed.', 'cloudfiles-wordpress-media-library-folders-cloud');
					}
				} catch (Exception $e) {
					error_log($e->getMessage());
				}
			}else{
				$message = esc_html__('Provider does not exist.', 'cloudfiles-wordpress-media-library-folders-cloud');
			}

			$data = array(
				'status' => $status,
        		'message' => $message
        	);
			wp_send_json_success($data);
			exit;
		}
		wp_send_json_error();
		exit;
	}

	private static function get_provider_data($p, $action_type, $id='', $requestData = []){
		$data = [];
		$provider = new Cloudfiles_Wordpress_Media_Library_Folders_Cloud_Pro($p);
		if($provider->is_enable()){
			switch ($action_type) {
				case 'get_node':
					$data = $provider->get_node();
					break;
				case 'sync_node':
					if($p == CLOUDFILES_WORDPRESS_MEDIA_LIBRARY_FOLDERS_CLOUD_LOCAL){
						$data = array(
							'status' => 'fail',
							'message' => esc_html__("Can't sync media library folder.", 'cloudfiles-wordpress-media-library-folders-cloud')
						);
					}else{
						$data = array(
							'status' => 'success',
							'message' => esc_html__('Synchronization completed.', 'cloudfiles-wordpress-media-library-folders-cloud')
						);
						$data_selected = [];
						$data_selected[] = [
							'id' => get_term_meta($requestData['id'], 'noucloudfiles_folder_id', true),
							'provider' => $requestData['provider']
						];
						try {
							$sync = new Cloudfiles_Wordpress_Media_Library_Folders_Cloud_Sync_Helper($provider);
							$result = $sync->do_sync_from_cloud_to_local($data_selected);
						} catch (\Throwable $th) {
							$data = array(
								'status' => 'fail',
								'message' => esc_html__('Synchronization has been failed. Please try again.', 'cloudfiles-wordpress-media-library-folders-cloud')
							);
						}
					}
					break;
				case 'delete_node':
					$data = array(
						'status' => 'success',
						'message' => esc_html__('Delete folder successfuly.', 'cloudfiles-wordpress-media-library-folders-cloud')
					);
					$result = $provider->delete_folder($requestData);
					if(!$result){
						$data = array(
							'status' => 'fail',
							'message' => esc_html__('Delete folder failed.', 'cloudfiles-wordpress-media-library-folders-cloud')
						);
					}
					break;
				case 'move_node':
					$data = array(
						'status' => 'success',
						'message' => esc_html__('Move folder successfuly.', 'cloudfiles-wordpress-media-library-folders-cloud')
					);
					$result = $provider->move_node($requestData);
					if(!$result){
						$data = array(
							'status' => 'fail',
							'message' => esc_html__('Move folder failed.', 'cloudfiles-wordpress-media-library-folders-cloud')
						);
					}
					break;
				case 'copy_node':
					$data = array(
						'status' => 'success',
						'message' => esc_html__('Copy folder successfuly.', 'cloudfiles-wordpress-media-library-folders-cloud')
					);
					$result = $provider->copy_node($requestData);
					if(!$result){
						$data = array(
							'status' => 'fail',
							'message' => esc_html__('Copy folder failed.', 'cloudfiles-wordpress-media-library-folders-cloud')
						);
					}
					break;
				case 'move_file_to_folder':
					$data = array(
						'status' => 'success',
						'message' => esc_html__('Move attachment to folder successfuly.', 'cloudfiles-wordpress-media-library-folders-cloud')
					);
					$result = $provider->move_file_to_folder($requestData);
					if(!$result){
						$data = array(
							'status' => 'fail',
							'message' => esc_html__('Move attachment to folder failed.', 'cloudfiles-wordpress-media-library-folders-cloud')
						);
					}
					break;
				case 'rename_node':
					$data = array(
						'status' => 'success',
						'message' => esc_html__('Rename folder successfuly.', 'cloudfiles-wordpress-media-library-folders-cloud')
					);
					$result = $provider->rename_folder($requestData);
					if(!$result){
						$data = array(
							'status' => 'fail',
							'message' => esc_html__('Rename folder failed.', 'cloudfiles-wordpress-media-library-folders-cloud')
						);
					}
					break;
				case 'get_folder_cloud':
					$data = $provider->get_folder_cloud();
					break;
				default:
					break;
			}
		}
		return $data;
	}

	public static function get_folders(){
		$nonce = $_REQUEST['_wpnonce'];
		if ( wp_verify_nonce( $nonce, 'noucloudfiles_params_nonce' ) ) {

			$provider = isset($_REQUEST['provider']) ? $_REQUEST['provider'] : '';
			$action_type = isset($_REQUEST['operation']) ? $_REQUEST['operation'] : 'get_node';
			$id = isset($_REQUEST['id']) ? $_REQUEST['id'] : '';
			$data = [];
			
			if($provider){
				$data = self::get_provider_data($provider, $action_type, $id, $_POST);
			}else{
				$providers = CLOUDFILES_WORDPRESS_MEDIA_LIBRARY_FOLDERS_CLOUD_PROVIDERS;
				foreach ($providers as $p) {
					$folder = self::get_provider_data($p, $action_type, $id, $_POST);
					if(count($folder) > 0){
						$data[] = $folder;
					}
				}
			}

			echo json_encode($data);
			exit();
		}
		wp_send_json_error();
		exit;
	}
	public static function create_authorize_url(){
		$nonce = $_REQUEST['_wpnonce'];
		if ( wp_verify_nonce( $nonce, 'noucloudfiles_params_nonce' ) ) {
			$client = $_REQUEST['client'];
			$data = array(
            		'status' => 'success',
            		'authorize_url' => '',
            	);
			switch ($client) {
				case CLOUDFILES_WORDPRESS_MEDIA_LIBRARY_FOLDERS_CLOUD_ONEDRIVE:
					$provider = new Cloudfiles_Wordpress_Media_Library_Folders_Cloud_Provider_Onedrive();
					$data['authorize_url'] = $provider->getAuthUrl();
					wp_send_json_success($data);
					break;
				case CLOUDFILES_WORDPRESS_MEDIA_LIBRARY_FOLDERS_CLOUD_ONEDRIVE_BUSINESS:
					$provider = new Cloudfiles_Wordpress_Media_Library_Folders_Cloud_Provider_Onedrive_Business();
					$data['authorize_url'] = $provider->getAuthUrl();
					wp_send_json_success($data);
					break;
				
				default:
					wp_send_json_error();
					break;
			}
		}
		wp_send_json_error();
		exit;
	}

	public static function save_splitter(){
		$nonce = $_REQUEST['_wpnonce'];
		if ( wp_verify_nonce( $nonce, 'noucloudfiles_params_nonce' ) ) {
			$width = $_POST['splitter_width'];
	        if (update_option('noucloudfiles_splitter_width', $width)) {
	            wp_send_json_success();
	        } else {
	            wp_send_json_error();
	        }
		}
		wp_send_json_error();
	}

	public static function create_folder(){
		$nonce = $_REQUEST['_wpnonce'];
		if ( wp_verify_nonce( $nonce, 'noucloudfiles_params_nonce' ) ) {
			
			$provider 		= isset($_POST["provider"]) ? $_POST["provider"] : CLOUDFILES_WORDPRESS_MEDIA_LIBRARY_FOLDERS_CLOUD_LOCAL;
			$taxonomy 		= isset($_POST["taxonomy"]) ? $_POST["taxonomy"] : CLOUDFILES_WORDPRESS_MEDIA_LIBRARY_FOLDERS_CLOUD_TANONOMY_NAME;
	        $new_name 		= isset($_POST["name"]) ? $_POST["name"] : '';
	        $parent 		= isset($_POST["parent"]) ? $_POST["parent"] : '0';

	        if($provider == $parent){
	        	$parent = 0;
	        }

	        $provider = new Cloudfiles_Wordpress_Media_Library_Folders_Cloud_Pro($provider);
	        $term_new = $provider->client->create_folder(['name' => $new_name, 'parent' => $parent]);
	        
            if (!$term_new) {
                wp_send_json_error(array('status' => 'fail', 'message' => esc_html__('Folder create failed', 'cloudfiles-wordpress-media-library-folders-cloud')));
            }

            wp_send_json_success(
            	array(
            		'term_id' => $term_new["term_id"], 
            		'term_name' => $term_new['name'],
            		'parent' => $parent,
            		'provider' => $provider,
            		'taxonomy' => $taxonomy,
            		'status' => 'success',
            		'message' => esc_html__('Folder created successfully!', 'cloudfiles-wordpress-media-library-folders-cloud'),
            	)
            );
		}
		wp_send_json_error(array('status' => 'fail', 'message' => esc_html__('Security check', 'cloudfiles-wordpress-media-library-folders-cloud')));
	}
}