<?php
if ( ! defined( 'WPINC' ) ) {
	die;
}

function noucloudfiles_count_folders($taxonomy=CLOUDFILES_WORDPRESS_MEDIA_LIBRARY_FOLDERS_CLOUD_TANONOMY_NAME)
{
	global $wpdb;
    $query = 'SELECT count(*) as "count" from ' . $wpdb->prefix . "term_taxonomy" . ' WHERE taxonomy="' . $taxonomy . '"';
    $result = $wpdb->get_results($query);
    return intval($result[0]->count);
}

function noucloudfiles_get_valid_term_name($name, $parent, $taxonomy=CLOUDFILES_WORDPRESS_MEDIA_LIBRARY_FOLDERS_CLOUD_TANONOMY_NAME)
{
    if (!$parent) {
        $parent = 0;
    }

    $terms = get_terms(
        $taxonomy, 
        array(
            'parent' => $parent, 
            'hide_empty' => false
        )
    );

    $check = true;

    if (count($terms)) {
        foreach ($terms as $term) {
            if ($term->name === $name) {
                $check = false;
                break;
            }
        }
    } else {
        return $name;
    }

    if ($check) {
        return $name;
    }

    $arr = explode('_', $name);

    if ($arr && count($arr) > 1) {
        $suffix = array_values(array_slice($arr, -1))[0];
        array_pop($arr);
        $origin_name = implode($arr);
        if (intval($suffix)) {
            $name = $origin_name . '_' . (intval($suffix) + 1);
        }
    } else {
        $name = $name . '_1';
    }
    $name = noucloudfiles_get_valid_term_name($name, $parent);
    return $name;

}

function noucloudfiles_terms($taxonomy, $parent)
{   
    $result = false;
    try {
        global $wpdb;
        $query = "SELECT * 
                FROM " . $wpdb->prefix . "terms AS t, " . $wpdb->prefix . "term_taxonomy AS tt
                WHERE tt.taxonomy = '".esc_sql($taxonomy)."' AND t.term_id = tt.term_id AND tt.parent = ".esc_sql((int) $parent);
        $result = $wpdb->get_results($query);
    } catch (Exception $e) {
        //
    }
    return $result;
}

function noucloudfiles_term_tree_array($taxonomy, $parent)
{   
    $children = [];
    try {
        $result = noucloudfiles_terms($taxonomy, $parent);
        if($result){
            foreach ($result as $term) {
                $term->children = noucloudfiles_term_tree_array($taxonomy, $term->term_id);
                $children[] = $term;
            }
        }
    } catch (Exception $e) {
        //
    }
    return $children;
}

function noucloudfiles_tree_to_flat_array($array)
{
    $result = [];
    foreach ($array as $key => $row) {

        $item = new stdClass();
        $item->term_id = $row->term_id;
        $item->name = $row->name;
        $item->parent = $row->parent;
        $item->count = $row->count;

        $result[] = $item;
        if (count($row->children) > 0) {
            $result = array_merge($result, noucloudfiles_tree_to_flat_array($row->children));
        }
    }

    return $result;
}

function noucloudfiles_folder_counter($term_count, $term_id = null)
{
    global $sitepress, $wpdb;
    $is_wpml_active = $sitepress !== null && get_class($sitepress) === "SitePress";
    if ($is_wpml_active && $term_id !== null) {
        $lang = $sitepress->get_current_language();
        $table_name = $wpdb->prefix . 'icl_translations';

        $counter = (int) $wpdb->get_var("SELECT COUNT(*)
        FROM $table_name AS wpmlt
        INNER JOIN $wpdb->term_relationships AS term_rela ON term_rela.object_id = wpmlt.element_id
        WHERE wpmlt.element_type =  'post_attachment'
        AND term_rela.term_taxonomy_id = $term_id
        AND wpmlt.language_code =  '$lang'");
        return $counter ? $counter : false;
    } else {
        return $term_count ? $term_count : false;
    }
}

/**
 * Get extension
 *
 * @param string $file File name
 *
 * @return string
 */
function noucloudfiles_getExt($file)
{
    $dot = strrpos($file, '.') + 1;

    return substr($file, $dot);
}

/**
 * Strips the last extension off of a file name
 *
 * @param string $file The file name
 *
 * @return string  The file name without the extension
 */
function noucloudfiles_stripExt($file)
{
    return preg_replace('#\.[^.]*$#', '', $file);
}

/**
 * Sanitize a string destined to be a tooltip.
 *
 * @since  Tooltips are encoded with htmlspecialchars to prevent XSS. Should not be used in conjunction with esc_attr()
 * @param  string $var Data to sanitize.
 * @return string
 */
function noucloudfiles_sanitize_tooltip( $var ) {
    return htmlspecialchars(
        wp_kses(
            html_entity_decode( $var ),
            array(
                'br'     => array(),
                'em'     => array(),
                'strong' => array(),
                'small'  => array(),
                'span'   => array(),
                'ul'     => array(),
                'li'     => array(),
                'ol'     => array(),
                'p'      => array(),
            )
        )
    );
}

/**
 * Display a help tip.
 *
 * @since  1.0.0
 *
 * @param  string $tip        Help tip text.
 * @param  bool   $allow_html Allow sanitized HTML if true or escape.
 * @return string
 */
function noucloudfiles_help_tip( $tip, $allow_html = false ) {
    if ( $allow_html ) {
        $tip = noucloudfiles_sanitize_tooltip( $tip );
    } else {
        $tip = esc_attr( $tip );
    }

    return '<span class="tooltip noucloudfiles-help-tip dashicons dashicons-editor-help" title="' . $tip . '"></span>';
}

/**
 * Cache list folder from cloud.
 *
 * @since  1.0.0
 *
 * @param  string $provider.
 * @param  int   $timeout.
 * @return array
 */
function noucloudfiles_cache_list_folder( $provider, $data, $timeout=60*5 ) {
    $key = '_cache_folder_list_'.$provider;
    // Get any existing copy of our transient data
    if ( false === ( $special_query_results = get_transient( $key ) ) ) {
        // It wasn't there, so regenerate the data and save the transient
        $special_query_results = $data;
        set_transient( $key, $special_query_results, $timeout );
    }

    return $special_query_results;
}

function noucloudfiles_info_cloud($provider, $action, $args=[]){
    $pro = new Cloudfiles_Wordpress_Media_Library_Folders_Cloud_Pro($provider);
    $provider = $pro->client;

    try{
        switch($action){
            case "get_dir_by_name":
                // return $provider->filesystem->listContents();
                // return $provider->filesystem->getAdapter()->getPathPrefix();
                return $provider->filesystem->getMetadata($args['dir_name']);
                break;
            default:
                return false;
                break;
        }
    } catch (Exception $e) {
        //
    }

    return false;
}


function noucloudfiles_get_term_id_by_folder_id($taxonomy, $folder_id)
{   
    $result = false;
    try {
        global $wpdb;
        $query = "SELECT tm.term_id
                FROM " . $wpdb->prefix . "terms AS t, " . $wpdb->prefix . "term_taxonomy AS tt, " . $wpdb->prefix . "termmeta AS tm
                WHERE tt.taxonomy = '".esc_sql($taxonomy)."' AND t.term_id = tt.term_id AND tm.meta_key = 'noucloudfiles_folder_id' AND tm.meta_value = '".$folder_id."'";
        $result = $wpdb->get_row($query);
        if($result){
            return $result->term_id;
        }
    } catch (Exception $e) {
        //
    }
    return $result;
}

function noucloudfiles_prepare_data_adapter($provider, $data)
{   
    $default = [
        'provider' => $provider,
        'name' => '',
        'type' => '',
        'path' => '',
        'filename' => '',
        'extension' => '',
        'mimetype' => '',
        'size' => '',
        'dirname' => '',
        'basename' => '',
        'cloud_id' => ''
    ];

    if(!isset($data['mimetype'])){
        if(!empty($data['extension'])){
            try{
                $mimes = new \Mimey\MimeTypes;
                // Convert extension to MIME type:
                $default['mimetype'] = $mimes->getMimeType($data['extension']);
            } catch (Exception $e) {
                //
            }
        }
    }

    $data = wp_parse_args( $data, $default );
    return $data;
}


/**
 * Clean variables using sanitize_text_field. Arrays are cleaned recursively.
 * Non-scalar values are ignored.
 *
 * @param string|array $var Data to sanitize.
 * @return string|array
 */
function noucloudfiles_clean( $var ) {
	if ( is_array( $var ) ) {
		return array_map( 'noucloudfiles_clean', $var );
	} else {
		return is_scalar( $var ) ? sanitize_text_field( $var ) : $var;
	}
}


/**
 * Parse a relative date option from the settings API into a standard format.
 *
 * @since 1.0
 * @param mixed $raw_value Value stored in DB.
 * @return array Nicely formatted array with number and unit values.
 */
function noucloudfiles_parse_relative_date_option( $raw_value ) {
	$periods = array(
		'days'   => esc_html__( 'Day(s)', 'cloudfiles-wordpress-media-library-folders-cloud' ),
		'weeks'  => esc_html__( 'Week(s)', 'cloudfiles-wordpress-media-library-folders-cloud' ),
		'months' => esc_html__( 'Month(s)', 'cloudfiles-wordpress-media-library-folders-cloud' ),
		'years'  => esc_html__( 'Year(s)', 'cloudfiles-wordpress-media-library-folders-cloud' ),
	);

	$value = wp_parse_args(
		(array) $raw_value,
		array(
			'number' => '',
			'unit'   => 'days',
		)
	);

	$value['number'] = ! empty( $value['number'] ) ? absint( $value['number'] ) : '';

	if ( ! in_array( $value['unit'], array_keys( $periods ), true ) ) {
		$value['unit'] = 'days';
	}

	return $value;
}

/**
 * Generator the WordPress loop.
 *
 * @since 1.0
 * @param WP_Query|WP_Post[] $iterable
 *
 * @return Generator
 */
function noucloudfiles_lazy_loop($iterable = null){
    return Cloudfiles_Wordpress_Media_Library_Folders_Cloud_Lazy_Query_Loop::generator($iterable);
}

/**
 * Simple function to get category post count including all subcategories
 *
 * @link http://wordpress.stackexchange.com/a/91551 Stackexchange
 * @param  int $cat_id Category ID
 * @return int         Total post count
 */
function noucloudfiles_total_cat_post_count( $cat_id, $taxonomy, $post_type = 'attachment' ) {
    $q = new WP_Query( array(
        'post_type' => $post_type,
        'posts_per_page' => -1,
        'post_status' => 'any',
        'tax_query' => array(
            array(
                'taxonomy' => $taxonomy,
                'field' => 'id',
                'terms' => $cat_id
            ),
        ),
        'fields' => 'ids',
    ) );
    return $q->post_count;
}

function noucloudfiles_dropdown_folder_media(){
    $p = CLOUDFILES_WORDPRESS_MEDIA_LIBRARY_FOLDERS_CLOUD_LOCAL;
    $provider = new Cloudfiles_Wordpress_Media_Library_Folders_Cloud_Pro($p);
    if($provider->is_enable()){
        $dropdown_options = array(
            'show_option_none'  => sprintf('%s %s', esc_html__('Folder', 'cloudfiles-wordpress-media-library-folders-cloud'), $provider->client->get_name()),
            'hide_empty'        => false,
            'hierarchical'      => true,
            'orderby'           => 'name',
            'taxonomy'          => CLOUDFILES_WORDPRESS_MEDIA_LIBRARY_FOLDERS_CLOUD_TANONOMY_NAME,
            'name'              => 'noucloudfiles_'. $p .'_folder',
            'id'                => $p.'-media-category-upload'
        );
        wp_dropdown_categories($dropdown_options);
    }
}

function noucloudfiles_folders_tree_to_flat_array($array)
{
    $result = [];
    foreach ($array as $key => $row) {
        if (count($row['children']) > 0) {
            $result = array_merge($result, noucloudfiles_folders_tree_to_flat_array($row['children']));
        }
        unset($row['children']);
        $result[] = $row;
    }

    return $result;
}

function noucloudfiles_build_embed_url($url, $pdfID){
    $url = str_replace('?dl=0&raw=1', '?dl=1', $url);
    return sprintf('//docs.google.com/gview?embedded=true&url=%s', $url);
}

function noucloudfiles_upload_file_to_cloud($provider_key, $attachment_id, $term_id){
    
    if($provider_key == CLOUDFILES_WORDPRESS_MEDIA_LIBRARY_FOLDERS_CLOUD_LOCAL){
        return false;
    }

    $folder_id = get_term_meta($term_id, 'noucloudfiles_folder_id', true);
    $folder = get_term_meta($term_id, 'noucloudfiles_folder_info', true);
    if(empty($folder_id)){
        return false;
    }

    $provider = new Cloudfiles_Wordpress_Media_Library_Folders_Cloud_Pro($provider_key);
	if(!$provider->is_enable()){
        return false;
    }

    $attachment_key = get_post_meta( $attachment_id, '_wp_attached_file', true );
    $upload_dir 	= wp_upload_dir();
    $basedir 		= $upload_dir['basedir'];
    $path_to_file 	= $basedir . "/" . $attachment_key;
    $path_date 	    = str_replace(basename($attachment_key), '', $attachment_key);
    $array_files    = [];
    $array_files[]  = basename($attachment_key);

    if(!file_exists($path_to_file)){
        return false;
    }

    // Getting the rest of the sizes of the file to add to the array
	$metadatas = wp_get_attachment_metadata( $attachment_id );

	if ( ! empty( $metadatas ) && isset( $metadatas['sizes'] ) )
	{
		foreach ( $metadatas['sizes'] as $metadata ) {
			if (!in_array($metadata['file'], $array_files)) {
                $array_files[] = $metadata['file'];
            }
		}
    }
    
    $results = [];
    $data = get_post_meta( $attachment_id, 'noucloudfiles_attachment_set_folder', true);
    $urls = get_post_meta( $attachment_id, 'noucloudfiles_file_urls', true );
    $uploaded_urls = [];
    
    foreach($array_files as $file_key){
        $path_to_file = $basedir . "/" . $path_date . $file_key;
        if(file_exists($path_to_file)){
            $file_name      = basename($file_key);
            $upload_path 	= $folder_id.'/'.$file_name;
            $contents 		= file_get_contents($path_to_file);
            try {
                $result 	= $provider->upload($upload_path, $contents);
                if($result){
					try {
						$file_data 	    = $provider->client->get_meta_data($upload_path);
                        $file 		    = noucloudfiles_prepare_data_adapter($provider_key, $file_data);
                        
                        $file['path']   = $upload_path;

                        $url 		    = $provider->client->get_shared_link($file);
						if($url){
                            $uploaded_urls[$file_name] = ($url ? $url : '');
                            
                            if( basename($attachment_key) == $file_key ){
                                if(!noucloudfiles_check_attachment_exists_meta($attachment_id, 'noucloudfiles_file_id')){
                                    update_post_meta($attachment_id, 'noucloudfiles_file_id', $provider->client->format_id_folder($file['path']));
                                }

                                if(!noucloudfiles_check_attachment_exists_meta($attachment_id, 'noucloudfiles_order')){
                                    update_post_meta($attachment_id, 'noucloudfiles_order', 0);
                                }

                                if(!noucloudfiles_check_attachment_exists_meta($attachment_id, 'noucloudfiles_size')){
                                    update_post_meta($attachment_id, 'noucloudfiles_size', $file['size']);
                                }

                                if(!noucloudfiles_check_attachment_exists_meta($attachment_id, 'noucloudfiles_file_info')){
                                    update_post_meta($attachment_id, 'noucloudfiles_file_info', $file);
                                }

                                if(!noucloudfiles_check_attachment_exists_meta($attachment_id, 'noucloudfiles_folder_info')){
                                    update_post_meta($attachment_id, 'noucloudfiles_folder_info', $folder);
                                }

                                if(!noucloudfiles_check_attachment_exists_meta($attachment_id, 'noucloudfiles_provider_id')){
                                    update_post_meta($attachment_id, 'noucloudfiles_provider_id', $provider_key);
                                }

                                if(!noucloudfiles_check_attachment_exists_meta($attachment_id, 'noucloudfiles_file_url')){
                                    update_post_meta($attachment_id, 'noucloudfiles_file_url', $url);
                                }

                                if(!noucloudfiles_check_attachment_exists_meta($attachment_id, 'noucloudfiles_author')){
                                    update_post_meta($attachment_id, 'noucloudfiles_author', get_current_user_id());
                                }
        					}
        
						}
					} catch (\Throwable $th) {
						error_log($th->getMessage());
					}
                }
            } catch (\Throwable $th) {
                error_log($th->getMessage());
            }
        }
    }

    if(count($uploaded_urls) > 0){

        if(!is_array($urls)){
            $urls = [];
        }

        $urls[$provider_key] = $uploaded_urls;
        update_post_meta( $attachment_id, 'noucloudfiles_file_urls', $urls );
    }
}

function noucloudfiles_check_attachment_exists_meta($attachment_id, $meta_key){
    $meta_value = get_post_meta($attachment_id, $meta_key, true);
    if(!empty($meta_value)){
        return $meta_value;
    }
    return false;
}

function noucloudfiles_get_url_from_file_name($attachment_id, $provider_key, $file_name){
    $urls = get_post_meta($attachment_id, 'noucloudfiles_file_urls', true);
    if(!empty($urls) && is_array($urls)){
        try {
            return isset($urls[$provider_key]) && isset($urls[$provider_key][$file_name]) ? $urls[$provider_key][$file_name] : false;
        } catch (\Throwable $th) {
            return false;
        }
    }
    return false;
}

/**
 * Remove size from filename (image[-100x100].jpeg).
 *
 * @param string $url
 * @param bool   $remove_extension
 *
 * @return string
 */
function noucloudfiles_remove_size_from_filename( $url, $remove_extension = false ) {
    $url = preg_replace( '/^(\S+)-[0-9]{1,4}x[0-9]{1,4}(\.[a-zA-Z0-9\.]{2,})?/', '$1$2', $url );

    if ( $remove_extension ) {
        $ext = pathinfo( $url, PATHINFO_EXTENSION );
        $url = str_replace( ".$ext", '', $url );
    }

    return $url;
}

function noucloudfiles_get_folder_by_path($provider_key, $path){
    $folder = false;
    $list_folders = get_option('noucloudfiles_folder_list_'.$provider_key);
    if($list_folders['children']){
        $data_selected = noucloudfiles_folders_tree_to_flat_array($list_folders['children']);
        foreach($data_selected as $f){
            if($f['id'] == $path){
                $folder = $f;
                break;
            }
        }
    }

    return $folder;
}