<?php

/**
 * The plugin bootstrap file
 *
 * This file is read by WordPress to generate the plugin information in the plugin
 * admin area. This file also includes all of the dependencies used by the plugin,
 * registers the activation and deactivation functions, and defines a function
 * that starts the plugin.
 *
 * @link              https://themeforest.net/user/nouthemes/portfolio
 * @since             1.0.0
 * @package           Cloudfiles_Wordpress_Media_Library_Folders_Cloud
 *
 * @wordpress-plugin
 * Plugin Name:       Cloudfiles - WordPress Media Library Folders Cloud
 * Plugin URI:        https://codecanyon.net/user/nouthemes/portfolio
 * Description:       Cloudfiles is a reliable lifesaver to help you better organize your WordPress media library with just a few clicks. Integrated with google drive, dropbox, onedrive to save storage space and power from cloud.
 * Version:           1.0.3
 * Author:            Nouthemes
 * Author URI:        https://themeforest.net/user/nouthemes/portfolio
 * License:           GPL-2.0+
 * License URI:       http://www.gnu.org/licenses/gpl-2.0.txt
 * Text Domain:       cloudfiles-wordpress-media-library-folders-cloud
 * Domain Path:       /languages
 */

// If this file is called directly, abort.
if ( ! defined( 'WPINC' ) ) {
	die;
}


/**
 * Currently plugin version.
 * Start at version 1.0.0 and use SemVer - https://semver.org
 * Rename this for your plugin and update it as you release new versions.
 */
define( 'CLOUDFILES_WORDPRESS_MEDIA_LIBRARY_FOLDERS_CLOUD_VERSION', '1.0.3' );
define( 'CLOUDFILES_WORDPRESS_MEDIA_LIBRARY_FOLDERS_CLOUD_DIR', plugin_dir_path( __FILE__ ) );
define( 'CLOUDFILES_WORDPRESS_MEDIA_LIBRARY_FOLDERS_CLOUD_TANONOMY_NAME', 'noucloudfiles_tax_local' );
define( 'CLOUDFILES_WORDPRESS_MEDIA_LIBRARY_FOLDERS_CLOUD_GOOGLE_DRIVE_TANONOMY_NAME', 'noucloudfiles_tax_google_drive' );
define( 'CLOUDFILES_WORDPRESS_MEDIA_LIBRARY_FOLDERS_CLOUD_DROPBOX_TANONOMY_NAME', 'noucloudfiles_tax_dropbox' );
define( 'CLOUDFILES_WORDPRESS_MEDIA_LIBRARY_FOLDERS_CLOUD_ONEDRIVE_TANONOMY_NAME', 'noucloudfiles_tax_onedrive' );
define( 'CLOUDFILES_WORDPRESS_MEDIA_LIBRARY_FOLDERS_CLOUD_AWS_TANONOMY_NAME', 'noucloudfiles_tax_aws' );
define( 'CLOUDFILES_WORDPRESS_MEDIA_LIBRARY_FOLDERS_CLOUD_ONEDRIVE_BUSINESS_TANONOMY_NAME', 'noucloudfiles_tax_onedrive_b' );
define( "CLOUDFILES_WORDPRESS_MEDIA_LIBRARY_FOLDERS_CLOUD_DIR_FILE", __FILE__ );
/**
* Providers supported
*/
define( 'CLOUDFILES_WORDPRESS_MEDIA_LIBRARY_FOLDERS_CLOUD_LOCAL', 'local');
define( 'CLOUDFILES_WORDPRESS_MEDIA_LIBRARY_FOLDERS_CLOUD_GOOGLE_DRIVE', 'google_drive');
define( 'CLOUDFILES_WORDPRESS_MEDIA_LIBRARY_FOLDERS_CLOUD_DROPBOX', 'dropbox');
define( 'CLOUDFILES_WORDPRESS_MEDIA_LIBRARY_FOLDERS_CLOUD_ONEDRIVE', 'onedrive');
define( 'CLOUDFILES_WORDPRESS_MEDIA_LIBRARY_FOLDERS_CLOUD_AWS', 'aws');
define( 'CLOUDFILES_WORDPRESS_MEDIA_LIBRARY_FOLDERS_CLOUD_ONEDRIVE_BUSINESS', 'onedrive_business');
define( 'CLOUDFILES_WORDPRESS_MEDIA_LIBRARY_FOLDERS_CLOUD_PROVIDERS', 
	[
		CLOUDFILES_WORDPRESS_MEDIA_LIBRARY_FOLDERS_CLOUD_LOCAL,
        CLOUDFILES_WORDPRESS_MEDIA_LIBRARY_FOLDERS_CLOUD_GOOGLE_DRIVE,
        CLOUDFILES_WORDPRESS_MEDIA_LIBRARY_FOLDERS_CLOUD_AWS,
        CLOUDFILES_WORDPRESS_MEDIA_LIBRARY_FOLDERS_CLOUD_DROPBOX,
        CLOUDFILES_WORDPRESS_MEDIA_LIBRARY_FOLDERS_CLOUD_ONEDRIVE,
        CLOUDFILES_WORDPRESS_MEDIA_LIBRARY_FOLDERS_CLOUD_ONEDRIVE_BUSINESS
	]
);

define( 'CLOUDFILES_WORDPRESS_MEDIA_LIBRARY_FOLDERS_CLOUD_TANONOMIES', 
    [
        CLOUDFILES_WORDPRESS_MEDIA_LIBRARY_FOLDERS_CLOUD_TANONOMY_NAME,
        CLOUDFILES_WORDPRESS_MEDIA_LIBRARY_FOLDERS_CLOUD_GOOGLE_DRIVE_TANONOMY_NAME,
        CLOUDFILES_WORDPRESS_MEDIA_LIBRARY_FOLDERS_CLOUD_AWS_TANONOMY_NAME,
        CLOUDFILES_WORDPRESS_MEDIA_LIBRARY_FOLDERS_CLOUD_DROPBOX_TANONOMY_NAME,
        CLOUDFILES_WORDPRESS_MEDIA_LIBRARY_FOLDERS_CLOUD_ONEDRIVE_TANONOMY_NAME,
        CLOUDFILES_WORDPRESS_MEDIA_LIBRARY_FOLDERS_CLOUD_ONEDRIVE_BUSINESS_TANONOMY_NAME
    ]
);

if (version_compare(PHP_VERSION, '7.0', '<')) {
    if (!function_exists('noucloudfiles_error_php_version')) {
        /**
         * Show notice
         *
         * @return void
         */
        function noucloudfiles_error_php_version()
        {
            echo '<div class="error"><p>';
            echo '<strong>Cloudfiles - WordPress Media Library Folders Cloud</strong>';
            echo ' need at least PHP 7.0 version, please update php before installing the plugin.</p></div>';
        }
    }

    //Add actions
    add_action('admin_notices', 'noucloudfiles_error_php_version');

    //Do not load anything more
    return;
}

/**
 * The code that runs during plugin activation.
 * This action is documented in includes/class-cloudfiles-wordpress-media-library-folders-cloud-activator.php
 */
function noucloudfiles_activate_plugin() {
	require_once plugin_dir_path( __FILE__ ) . 'includes/class-cloudfiles-wordpress-media-library-folders-cloud-activator.php';
	Cloudfiles_Wordpress_Media_Library_Folders_Cloud_Activator::activate();
}

/**
 * The code that runs during plugin deactivation.
 * This action is documented in includes/class-cloudfiles-wordpress-media-library-folders-cloud-deactivator.php
 */
function noucloudfiles_deactivate_plugin() {
	require_once plugin_dir_path( __FILE__ ) . 'includes/class-cloudfiles-wordpress-media-library-folders-cloud-deactivator.php';
	Cloudfiles_Wordpress_Media_Library_Folders_Cloud_Deactivator::deactivate();
}

register_activation_hook( __FILE__, 'noucloudfiles_activate_plugin' );
register_deactivation_hook( __FILE__, 'noucloudfiles_deactivate_plugin' );

/**
 * The core plugin class that is used to define internationalization,
 * admin-specific hooks, and public-facing site hooks.
 */
require plugin_dir_path( __FILE__ ) . 'functions.php';
require plugin_dir_path( __FILE__ ) . 'includes/class-cloudfiles-wordpress-media-library-folders-cloud.php';

/**
 * Begins execution of the plugin.
 *
 * Since everything within the plugin is registered via hooks,
 * then kicking off the plugin from this point in the file does
 * not affect the page life cycle.
 *
 * @since    1.0.0
 */
function noucloudfiles_run_plugin() {

	$plugin = new Cloudfiles_Wordpress_Media_Library_Folders_Cloud();
	$plugin->run();

}
noucloudfiles_run_plugin();
