<?php
/**
 * Admin View: Settings
 *
 * Cloudfiles_Wordpress_Media_Library_Folders_Cloud/admin/partials/settings
 */
if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

$noucloudfiles_current_tab = ! empty( $_REQUEST['tab'] ) ? sanitize_title( $_REQUEST['tab'] ) : 'general';
$tab_exists        = isset( $tabs[ $noucloudfiles_current_tab ] ) || has_action( 'noucloudfiles_sections_' . $noucloudfiles_current_tab ) || has_action( 'noucloudfiles_settings_' . $noucloudfiles_current_tab ) || has_action( 'noucloudfiles_settings_tabs_' . $noucloudfiles_current_tab );
$current_tab_label = isset( $tabs[ $noucloudfiles_current_tab ] ) ? $tabs[ $noucloudfiles_current_tab ] : '';
?>
<div class="wrap noucloudfiles">
<div class="noucloudfiles_loading"><?php esc_html_e('Loading', 'noucloudfiles');?>&#8230;</div>
	<form method="<?php echo esc_attr( apply_filters( 'noucloudfiles_settings_form_method_tab_' . $noucloudfiles_current_tab, 'post' ) ); ?>" id="mainform" action="" enctype="multipart/form-data" autocomplete="off">
		<input type="hidden" id="noucloudfiles_settings_nonce" name="noucloudfiles_settings_nonce" value="<?php echo esc_attr(wp_create_nonce('noucloudfiles_settings_nonce'));?>">
		<nav class="nav-tab-wrapper woo-nav-tab-wrapper">
			<?php
			foreach ( $tabs as $slug => $label ) {
				echo '<a href="' . esc_html( admin_url( 'admin.php?page=cloudfiles_wordpress_media_library_folders_cloud&tab=' . esc_attr( $slug ) ) ) . '" class="nav-tab ' . ( $noucloudfiles_current_tab === $slug ? 'nav-tab-active' : '' ) . '">' . esc_html( $label ) . '</a>';
			}

			do_action( 'noucloudfiles_settings_tabs' );

			?>
		</nav>
		<h1 class="screen-reader-text"><?php echo esc_html( $current_tab_label ); ?></h1>
		<?php
			do_action( 'noucloudfiles_sections_' . $noucloudfiles_current_tab );

			self::show_messages();
		?>
		<div uk-grid>
			<div class="uk-width-2-3">
				<div id="<?php echo esc_attr('noucloudfiles_tab_'.$noucloudfiles_current_tab);?>" class="settings-content">
					<?php
						do_action( 'noucloudfiles_before_settings_' . $noucloudfiles_current_tab );
						do_action( 'noucloudfiles_settings_' . $noucloudfiles_current_tab );
						do_action( 'noucloudfiles_settings_tabs_' . $noucloudfiles_current_tab );
						do_action( 'noucloudfiles_after_settings_' . $noucloudfiles_current_tab );
					?>
				</div>
				<p class="submit">
					<?php do_action( 'noucloudfiles_before_submit_' . $noucloudfiles_current_tab );?>
					<?php if ( empty( $GLOBALS['cloudfiles_hide_save_button'] ) ) : ?>
						<button name="save" class="uk-button uk-button-primary noucloudfiles-save-button" type="submit" value="1"><?php esc_html_e( 'Save changes', 'noucloudfiles' ); ?></button>
					<?php endif; ?>

					<?php if ( empty( $GLOBALS['cloudfiles_hide_active_button'] ) ) : ?>
						<button name="active_plugin" class="uk-button uk-button-primary" type="submit" value="1"><?php esc_html_e( 'Active plugin', 'noucloudfiles' ); ?></button>
					<?php else:?>
						<?php if ( empty( $GLOBALS['cloudfiles_hide_deactive_button'] ) ) : ?>
							<button name="active_plugin" class="uk-button uk-button-danger" type="submit" value="2"><?php esc_html_e( 'Deactive plugin', 'noucloudfiles' ); ?></button>
						<?php endif; ?>
					<?php endif; ?>
					
					<?php wp_nonce_field( 'noucloudfiles-settings' ); ?>
					<?php do_action( 'noucloudfiles_after_submit_' . $noucloudfiles_current_tab );?>
				</p>
			</div>
			<div class="uk-width-1-3">
				<?php
				foreach (CLOUDFILES_WORDPRESS_MEDIA_LIBRARY_FOLDERS_CLOUD_PROVIDERS as $p) {
					if($p != CLOUDFILES_WORDPRESS_MEDIA_LIBRARY_FOLDERS_CLOUD_LOCAL){
						$provider = new Cloudfiles_Wordpress_Media_Library_Folders_Cloud_Pro($p);
						if($provider->is_enable()){
							?>
							<div class="uk-margin uk-card uk-card-default uk-card-hover">
								<div class="uk-card-header">
							        <h3 class="uk-card-title"><?php echo esc_html($provider->client->name);?></h3>
							    </div>
						        <div class="uk-card-body">
						        	<?php $provider->client->sync_html();?>
						        </div>
					        </div>
							<?php
						}
					}
				}
				?>
		    </div>
		</div>
	</form>
</div>