(function ($) {
  'use strict';
  
  if (noucloudfiles_params.folders && wp.media && wp.media.view) {

    wp.media.view.Attachment.Library = wp.media.view.Attachment.Library.extend({
      className: function () { return 'attachment ' + this.model.get('noucloudfiles-cloud-class'); }
    });

    /**
     * Create a new Media Library Folder
     */
    if (noucloudfiles_params.folders.local) {
      var MediaLibraryFolderFilter = wp.media.view.AttachmentFilters.extend({
        id: 'local-media-category',

        createFilters: function () {
          var filters = {};
          // Formats the 'terms' we've included via wp_localize_script()
          _.each(noucloudfiles_params.folders.local.items || {}, function (value, index) {
            filters[value.term_id] = {
              text: value.term_name,
              props: {
                // Change this: key needs to be the WP_Query var for the taxonomy
                noucloudfiles_local_folder: value.term_id,
              }
            };
          });
          filters.all = {
            // Change this: use whatever default label you'd like
            text: noucloudfiles_params.folders.local.all,
            props: {
              // Change this: key needs to be the WP_Query var for the taxonomy
              noucloudfiles_local_folder: ''
            },
            priority: 10
          };
          this.filters = filters;
        }
      });
    }

    /**
     * Create a new Google drive Folder
     */
    if (noucloudfiles_params.folders.google_drive) {
      var GoogleDriveFolderFilter = wp.media.view.AttachmentFilters.extend({
        id: 'google_drive-media-category',

        createFilters: function () {
          var filters = {};
          // Formats the 'terms' we've included via wp_localize_script()
          _.each(noucloudfiles_params.folders.google_drive.items || {}, function (value, index) {
            filters[value.term_id] = {
              text: value.term_name,
              props: {
                // Change this: key needs to be the WP_Query var for the taxonomy
                noucloudfiles_google_drive_folder: value.term_id,
              }
            };
          });
          filters.all = {
            // Change this: use whatever default label you'd like
            text: noucloudfiles_params.folders.google_drive.all,
            props: {
              // Change this: key needs to be the WP_Query var for the taxonomy
              noucloudfiles_google_drive_folder: ''
            },
            priority: 10
          };
          this.filters = filters;
        }
      });
    }

    /**
     * Create a new One drive Folder
     */
    if (noucloudfiles_params.folders.onedrive) {
      var OneDriveFolderFilter = wp.media.view.AttachmentFilters.extend({
        id: 'onedrive-media-category',

        createFilters: function () {
          var filters = {};
          // Formats the 'terms' we've included via wp_localize_script()
          _.each(noucloudfiles_params.folders.onedrive.items || {}, function (value, index) {
            filters[value.term_id] = {
              text: value.term_name,
              props: {
                // Change this: key needs to be the WP_Query var for the taxonomy
                noucloudfiles_onedrive_folder: value.term_id,
              }
            };
          });
          filters.all = {
            // Change this: use whatever default label you'd like
            text: noucloudfiles_params.folders.onedrive.all,
            props: {
              // Change this: key needs to be the WP_Query var for the taxonomy
              noucloudfiles_onedrive_folder: ''
            },
            priority: 10
          };
          this.filters = filters;
        }
      });
    }

    /**
     * Create a new Dropbox Folder
     */
    if (noucloudfiles_params.folders.dropbox) {
      var DropboxFolderFilter = wp.media.view.AttachmentFilters.extend({
        id: 'dropbox-media-category',

        createFilters: function () {
          var filters = {};
          // Formats the 'terms' we've included via wp_localize_script()
          _.each(noucloudfiles_params.folders.dropbox.items || {}, function (value, index) {
            filters[value.term_id] = {
              text: value.term_name,
              props: {
                // Change this: key needs to be the WP_Query var for the taxonomy
                noucloudfiles_dropbox_folder: value.term_id,
              }
            };
          });
          filters.all = {
            // Change this: use whatever default label you'd like
            text: noucloudfiles_params.folders.dropbox.all,
            props: {
              // Change this: key needs to be the WP_Query var for the taxonomy
              noucloudfiles_dropbox_folder: ''
            },
            priority: 10
          };
          this.filters = filters;
        }
      });
    }

    /**
     * Create a new AWS
     */
    if (noucloudfiles_params.folders.aws) {
      var AwsFolderFilter = wp.media.view.AttachmentFilters.extend({
        id: 'aws-media-category',

        createFilters: function () {
          var filters = {};
          // Formats the 'terms' we've included via wp_localize_script()
          _.each(noucloudfiles_params.folders.aws.items || {}, function (value, index) {
            filters[value.term_id] = {
              text: value.term_name,
              props: {
                // Change this: key needs to be the WP_Query var for the taxonomy
                noucloudfiles_aws_folder: value.term_id,
              }
            };
          });
          filters.all = {
            // Change this: use whatever default label you'd like
            text: noucloudfiles_params.folders.aws.all,
            props: {
              // Change this: key needs to be the WP_Query var for the taxonomy
              noucloudfiles_aws_folder: ''
            },
            priority: 10
          };
          this.filters = filters;
        }
      });
    }

    /**
     * Create a new Onedrive Business
     */
    if (noucloudfiles_params.folders.onedrive_business) {
      var OnedriveBusinessFolderFilter = wp.media.view.AttachmentFilters.extend({
        id: 'onedrive_business-media-category',

        createFilters: function () {
          var filters = {};
          // Formats the 'terms' we've included via wp_localize_script()
          _.each(noucloudfiles_params.folders.onedrive_business.items || {}, function (value, index) {
            filters[value.term_id] = {
              text: value.term_name,
              props: {
                // Change this: key needs to be the WP_Query var for the taxonomy
                noucloudfiles_onedrive_business_folder: value.term_id,
              }
            };
          });
          filters.all = {
            // Change this: use whatever default label you'd like
            text: noucloudfiles_params.folders.onedrive_business.all,
            props: {
              // Change this: key needs to be the WP_Query var for the taxonomy
              noucloudfiles_onedrive_business_folder: ''
            },
            priority: 10
          };
          this.filters = filters;
        }
      });
    }

    /**
     * Extend and override wp.media.view.AttachmentsBrowser to include our new filter
     */
    var AttachmentsBrowser = wp.media.view.AttachmentsBrowser;
    wp.media.view.AttachmentsBrowser = wp.media.view.AttachmentsBrowser.extend({
      createToolbar: function () {
        // Make sure to load the original toolbar
        AttachmentsBrowser.prototype.createToolbar.call(this);

        if (noucloudfiles_params.folders.local) {
          this.toolbar.set('MediaLibraryFolderFilter', new MediaLibraryFolderFilter({
            controller: this.controller,
            model: this.collection.props,
            priority: -75
          }).render());
        }

        if (noucloudfiles_params.folders.google_drive) {
          this.toolbar.set('GoogleDriveFolderFilter', new GoogleDriveFolderFilter({
            controller: this.controller,
            model: this.collection.props,
            priority: -75
          }).render());
        }

        if (noucloudfiles_params.folders.onedrive) {
          this.toolbar.set('OneDriveFolderFilter', new OneDriveFolderFilter({
            controller: this.controller,
            model: this.collection.props,
            priority: -75
          }).render());
        }

        if (noucloudfiles_params.folders.onedrive_business) {
          this.toolbar.set('OnedriveBusinessFolderFilter', new OnedriveBusinessFolderFilter({
            controller: this.controller,
            model: this.collection.props,
            priority: -75
          }).render());
        }

        if (noucloudfiles_params.folders.dropbox) {
          this.toolbar.set('DropboxFolderFilter', new DropboxFolderFilter({
            controller: this.controller,
            model: this.collection.props,
            priority: -75
          }).render());
        }

        if (noucloudfiles_params.folders.aws) {
          this.toolbar.set('AwsFolderFilter', new AwsFolderFilter({
            controller: this.controller,
            model: this.collection.props,
            priority: -75
          }).render());
        }

      }
    });
  }

})(jQuery);