/*
 * Gutenberg block Javascript code
 */
var __                = wp.i18n.__; // The __() function for internationalization.
var createElement     = wp.element.createElement; // The wp.element.createElement() function to create elements.
var registerBlockType = wp.blocks.registerBlockType; // The registerBlockType() function to register blocks.

/**
 * Register block
 *
 * @param  {string}   name     Block name.
 * @param  {Object}   settings Block settings.
 * @return {?WPBlock}          Block itself, if registered successfully,
 *                             otherwise "undefined".
 */
registerBlockType(
	'noucloudfiles/document-embedder-viewer', // Block name. Must be string that contains a namespace prefix. Example: my-plugin/my-custom-block.	
	{
		title: noucloudfiles_params.document_embedder_title, // Block title. __() function allows for internationalization.
		icon: 'media-document', // Block icon from Dashicons. https://developer.wordpress.org/resource/dashicons/.
		category: 'common', // Block category. Group blocks together based on common traits E.g. common, formatting, layout widgets, embed.
		attributes: {
			pdfID: {
				type: 'number'
			},
			url: {
				type: 'string'
			},
			width: {
				type: 'string'
			},
			height: {
				type: 'string'
			}
		},

		// Defines the block within the editor.
		edit: function( props ) {
			
			var {attributes , setAttributes, focus, className} = props;
			
			var InspectorControls = wp.editor.InspectorControls;
			var Button = wp.components.Button;
			var RichText = wp.editor.RichText;
			var Editable = wp.blocks.Editable; // Editable component of React.
			var MediaUpload = wp.editor.MediaUpload;
			var btn = wp.components.Button;
			var TextControl = wp.components.TextControl;
			
			var onSelectPDF = function(media) {
				return props.setAttributes({
					url: media.url,
					pdfID: media.id
				});
			}

			function onChangeWidth(v) {
				setAttributes( {width: v} );
			}

			function onChangeHeight(v) {
				setAttributes( {height: v} );
			}

			return [
				createElement(
					MediaUpload,
					{
						onSelect: onSelectPDF,
						//type: 'application/pdf',
						value: attributes.pdfID,
						render: function(open) {
							return createElement(btn,{onClick: open.open },
								attributes.url ? noucloudfiles_params.document_title + ': ' + attributes.url : noucloudfiles_params.document_embedder_click)
						}
					}
				),
									
				createElement( InspectorControls, { key: 'inspector' }, // Display the block options in the inspector pancreateElement.
					createElement('div',{ className: 'pdf_div_main'}	,
						createElement(
							'hr',
							{},
						),
						createElement(
							'p',
							{},
							noucloudfiles_params.change_wh_title,
						),
						createElement(
							'hr',
							{},
						),
						createElement(
							'p',
							{},
							noucloudfiles_params.max_pixels_title
						),							
						createElement(
							TextControl,
							{
								label: noucloudfiles_params.change_w_title,
								value: attributes.width,
								onChange: onChangeWidth
							}
						),
						createElement(
							TextControl,
							{
								label: noucloudfiles_params.change_h_title,
								value: attributes.height,
								onChange: onChangeHeight
							}
						)
					),
				),
			];
		},

		// Defines the saved block.
		save: function( props ) {
			return createElement(
				'p',
				{
					className: props.className,
					key: 'return-key',
				},props.attributes.content);
		},
	}
);
