(function ($) {
	'use strict';

	var upload_folder = null,
	folder_selected = null,
	dragging_elements = [],
	tree = null, 
	html_sidebar = $("#noucloudfiles-sidebar").html(),
	wpUploader = null;

	if (wp && wp.Uploader) {
		wpUploader = wp.Uploader;
	}

	function generateDropdown($current_frame) {
		var clear_filters = void 0,
			my_medias = void 0,
			filter_type = '',
			filter_date = '',
			filter_size = '',
			filter_weight = '',
			sort_folder = '',
			sort_file = '';

		// Add folder ordering
		var folder_order_options = $current_frame.find('#local-media-category option');
		if (folder_order_options.length) {
			var order_folder_label = $current_frame.find('#local-media-category option:first-child').text();
			sort_folder = '<li class="noucloudfiles_filter_sort_folders">' + order_folder_label + '<span class="uk-margin-small-left uk-icon" uk-icon="chevron-right"></span><ul>';
			folder_order_options.each(function () {
				sort_folder += '<li class="filter-item" data-id="#local-media-category" data-value="' + $(this).val() + '">';
				sort_folder += $(this).html();
				if ($(this).is(':selected')) {
					sort_folder += '<span class="uk-margin-small-right uk-icon" uk-icon="check"></span>';
				}
				sort_folder += '</li>';
			});
			sort_folder += '</ul></li>';
		}

		var google_drive_folder_order_options = $current_frame.find('#google_drive-media-category option');
		if (google_drive_folder_order_options.length) {
			var order_folder_label = $current_frame.find('#google_drive-media-category option:first-child').text();
			sort_folder += '<li class="noucloudfiles_filter_sort_folders">' + order_folder_label + '<span class="uk-margin-small-left uk-icon" uk-icon="chevron-right"></span><ul>';
			google_drive_folder_order_options.each(function () {
				sort_folder += '<li class="filter-item" data-id="#google_drive-media-category" data-value="' + $(this).val() + '">';
				sort_folder += $(this).html();
				if ($(this).is(':selected')) {
					sort_folder += '<span class="uk-margin-small-right uk-icon" uk-icon="check"></span>';
				}
				sort_folder += '</li>';
			});
			sort_folder += '</ul></li>';
		}

		var dropbox_folder_order_options = $current_frame.find('#dropbox-media-category option');
		if (dropbox_folder_order_options.length) {
			var order_folder_label = $current_frame.find('#dropbox-media-category option:first-child').text();
			sort_folder += '<li class="noucloudfiles_filter_sort_folders">' + order_folder_label + '<span class="uk-margin-small-left uk-icon" uk-icon="chevron-right"></span><ul>';
			dropbox_folder_order_options.each(function () {
				sort_folder += '<li class="filter-item" data-id="#dropbox-media-category" data-value="' + $(this).val() + '">';
				sort_folder += $(this).html();
				if ($(this).is(':selected')) {
					sort_folder += '<span class="uk-margin-small-right uk-icon" uk-icon="check"></span>';
				}
				sort_folder += '</li>';
			});
			sort_folder += '</ul></li>';
		}

		var onedrive_folder_order_options = $current_frame.find('#onedrive-media-category option');
		if (onedrive_folder_order_options.length) {
			var order_folder_label = $current_frame.find('#onedrive-media-category option:first-child').text();
			sort_folder += '<li class="noucloudfiles_filter_sort_folders">' + order_folder_label + '<span class="uk-margin-small-left uk-icon" uk-icon="chevron-right"></span><ul>';
			onedrive_folder_order_options.each(function () {
				sort_folder += '<li class="filter-item" data-id="#onedrive-media-category" data-value="' + $(this).val() + '">';
				sort_folder += $(this).html();
				if ($(this).is(':selected')) {
					sort_folder += '<span class="uk-margin-small-right uk-icon" uk-icon="check"></span>';
				}
				sort_folder += '</li>';
			});
			sort_folder += '</ul></li>';
		}

		var onedrive_business_folder_order_options = $current_frame.find('#onedrive_business-media-category option');
		if (onedrive_business_folder_order_options.length) {
			var order_folder_label = $current_frame.find('#onedrive_business-media-category option:first-child').text();
			sort_folder += '<li class="noucloudfiles_filter_sort_folders">' + order_folder_label + '<span class="uk-margin-small-left uk-icon" uk-icon="chevron-right"></span><ul>';
			onedrive_business_folder_order_options.each(function () {
				sort_folder += '<li class="filter-item" data-id="#onedrive_business-media-category" data-value="' + $(this).val() + '">';
				sort_folder += $(this).html();
				if ($(this).is(':selected')) {
					sort_folder += '<span class="uk-margin-small-right uk-icon" uk-icon="check"></span>';
				}
				sort_folder += '</li>';
			});
			sort_folder += '</ul></li>';
		}

		var aws_folder_order_options = $current_frame.find('#aws-media-category option');
		if (aws_folder_order_options.length) {
			var order_folder_label = $current_frame.find('#aws-media-category option:first-child').text();
			sort_folder += '<li class="noucloudfiles_filter_sort_folders">' + order_folder_label + '<span class="uk-margin-small-left uk-icon" uk-icon="chevron-right"></span><ul>';
			aws_folder_order_options.each(function () {
				sort_folder += '<li class="filter-item" data-id="#aws-media-category" data-value="' + $(this).val() + '">';
				sort_folder += $(this).html();
				if ($(this).is(':selected')) {
					sort_folder += '<span class="uk-margin-small-right uk-icon" uk-icon="check"></span>';
				}
				sort_folder += '</li>';
			});
			sort_folder += '</ul></li>';
		}

		// Add media sorting
		var media_sort_options = $current_frame.find('#media-order-media option');
		if (media_sort_options.length) {
			sort_file = '<li class="noucloudfiles_filter_sort_files"> ' + noucloudfiles_params.order_img_label + '<span class="uk-margin-small-left uk-icon" uk-icon="chevron-right"></span><ul>';
			media_sort_options.each(function () {
				sort_file += '<li class="filter-item" data-id="#media-order-media" data-value="' + $(this).val() + '">';
				sort_file += $(this).html();
				if ($(this).is(':selected')) {
					sort_file += '<span class="uk-margin-small-right uk-icon" uk-icon="check"></span>';
				}
				sort_file += '</li>';
			});
			sort_file += '</ul></li>';
		}

		// add custom media type

		var noucloudfilesoption = '<option data-filetype="pdf" value="noucloudfiles-pdf">' + noucloudfiles_params.pdf + '</option>';
		noucloudfilesoption += '<option data-filetype="zip" value="noucloudfiles-zip">' + noucloudfiles_params.zip + '</option>';
		$('select[name="attachment-filter"] option[value="detached"]').before(noucloudfilesoption);

		// Add type filtering for both grid and list views
		if (noucloudfiles_params.media_mode == 'list') {
			var media_filter_options = $current_frame.find('#attachment-filter option');
		} else {
			media_filter_options = $current_frame.find('#media-attachment-filters option');
		}

		if (media_filter_options.length) {
			filter_type = '<li> ' + noucloudfiles_params.media_type + '<span class="uk-margin-small-left uk-icon" uk-icon="chevron-right"></span><ul>';
			media_filter_options.each(function () {
				if (noucloudfiles_params.media_mode == 'list') {
					filter_type += '<li class="filter-item" data-value="' + $(this).val() + '" data-id="#attachment-filter">';
				} else {
					filter_type += '<li class="filter-item" data-value="' + $(this).val() + '" data-id="#media-attachment-filters">';
				}

				filter_type += $(this).html();
				if ($(this).is(':selected')) {
					filter_type += '<span class="uk-margin-small-right uk-icon" uk-icon="check"></span>';
				}
				filter_type += '</li>';
			});

			filter_type += '</ul></li>';
		}

		// Add date filtering
		var date_filter_options = $current_frame.find('#media-attachment-date-filters option, #filter-by-date option');
		if (date_filter_options.length) {
			filter_date = '<li> ' + noucloudfiles_params.date + '<span class="uk-margin-small-left uk-icon" uk-icon="chevron-right"></span><ul>';
			date_filter_options.each(function () {
				if (noucloudfiles_params.media_mode == 'list') {
					filter_date += '<li class="filter-item" data-value="' + $(this).val() + '" data-id="#filter-by-date">';
				} else {
					filter_date += '<li class="filter-item" data-value="' + $(this).val() + '" data-id="#media-attachment-date-filters">';
				}
				filter_date += $(this).html();
				if ($(this).is(':selected')) {
					filter_date += '<span class="uk-margin-small-right uk-icon" uk-icon="check"></span>';
				}
				filter_date += '</li>';
			});
			filter_date += '</ul></li>';
		}

		// Add size filtering
		var size_filter_options = $current_frame.find('#media-attachment-size-filters option');
		if (size_filter_options.length) {
			if (size_filter_options.length <= 3) {
				filter_size = '<li> ' + noucloudfiles_params.lang_size + '<span class="uk-margin-small-left uk-icon" uk-icon="chevron-right"></span><ul>';
			} else {
				filter_size = '<li class="noucloudfiles_filter_sort_size"> ' + noucloudfiles_params.lang_size + '<span class="uk-margin-small-left uk-icon" uk-icon="chevron-right"></span><ul>';
			}

			size_filter_options.each(function () {
				filter_size += '<li class="filter-item" data-value="' + $(this).val() + '" data-id="#media-attachment-size-filters">';
				filter_size += $(this).html();
				if ($(this).is(':selected')) {
					filter_size += '<span class="uk-margin-small-right uk-icon" uk-icon="check"></span>';
				}
				filter_size += '</li>';
			});
			filter_size += '</ul></li>';
		}

		// Add weight filtering
		var weight_filter_options = $current_frame.find('#media-attachment-weight-filters option');
		if (weight_filter_options.length) {
			if (weight_filter_options.length <= 3) {
				filter_weight = '<li> ' + noucloudfiles_params.lang_weight + '<span class="uk-margin-small-left uk-icon" uk-icon="chevron-right"></span><ul>';
			} else {
				filter_weight = '<li class="noucloudfiles_filter_sort_weight"> ' + noucloudfiles_params.lang_weight + '<span class="uk-margin-small-left uk-icon" uk-icon="chevron-right"></span><ul>';
			}

			weight_filter_options.each(function () {
				filter_weight += '<li class="filter-item" data-value="' + $(this).val() + '" data-id="#media-attachment-weight-filters">';
				filter_weight += $(this).html();
				if ($(this).is(':selected')) {
					filter_weight += '<span class="uk-margin-small-right uk-icon" uk-icon="check"></span>';
				}
				filter_weight += '</li>';
			});
			filter_weight += '</ul></li>';
		}

		clear_filters = '<li class="clear_filters">' + noucloudfiles_params.clear_filters + '<span class="uk-margin-small-left uk-icon" uk-icon="close"></li>';

		// Own user media
		my_medias = '';

		return '<div class="noucloudfiles-filters-dropdown">\n<a class="noucloudfiles-filters-dropdown-button">' + noucloudfiles_params.sort_label + '</a>\n<ul class="noucloudfiles-filters-dropdown-list">\n' + clear_filters + '\n\n' + my_medias + '\n\n' + filter_type + '\n\n' + filter_date + '\n \n ' + filter_size + '\n\n ' + filter_weight + '\n\n                                ' + sort_folder + '\n                                \n                                ' + sort_file + '\n                            </ul>\n                        </div>\n                        ';
	}

	function noucloudfiles_noti(message, type) {
		/*
		Types:
		alert, success, warning, error, info/information

		Layouts:
		top, topLeft, topCenter, topRight, center, centerLeft, centerRight, bottom, bottomLeft, bottomCenter, bottomRight
		*/
		Noty.closeAll();
		new Noty({
			timeout: 5000,
			text: message,
			type: type,
			layout: 'topRight',
			animation: {
				open: 'animated bounceInRight', // Animate.css class names
				close: 'animated bounceOutRight' // Animate.css class names
			}
		}).show();
	}

	/**
	 * set a cookie
	 * @param cname cookie name
	 * @param cvalue cookie value
	 * @param exdays
	 */
	function setCookie(cname, cvalue, exdays) {
		var d = new Date();
		d.setTime(d.getTime() + exdays * 24 * 60 * 60 * 1000);
		var expires = "expires=" + d.toUTCString();
		document.cookie = cname + "=" + cvalue + ";" + expires + ";path=/";
	}

	/**
	 * get a cookie
	 * @param cname cookie name
	 * @returns {*}
	 */
	function getCookie(cname) {
		var name = cname + "=";
		var ca = document.cookie.split(';');
		for (var i = 0; i < ca.length; i++) {
			var c = ca[i];
			while (c.charAt(0) === ' ') {
				c = c.substring(1);
			}
			if (c.indexOf(name) === 0) {
				return c.substring(name.length, c.length);
			}
		}
		return "";
	}

	$(document).ready(function () {

		var $loading = $('#cloudfiles_loading');
		$.ajaxSetup({
			// complete: function () {
			// 	$loading.hide();
			// },
			error: function () { $loading.hide(); }
		});

		$('.noucloudfiles-save-button').on('click', function () {
			$loading.show();
		});

		$('body').on('change', '#local-media-category-upload', function () {
			upload_folder = $(this).val();

			if (typeof wpUploaderInit !== 'undefined') {
				wpUploaderInit.multipart_params['noucloudfiles_local_folder'] = (upload_folder !== null ? upload_folder : $('body').find('#local-media-category-upload').val());
			}
		});

		var node_selected = null;

		$('.tooltip').tooltipster({
			theme: 'tooltipster-borderless',
			maxWidth: 250
		});

		function get_data_folders() {
			return JSON.parse(localStorage.getItem('noucloudfiles_folders'));
		}

		if($('.upload-php').length > 0){
			var html = html_sidebar;
			$("#noucloudfiles-sidebar").remove();
			$("#wpbody .wrap").addClass('appended').before(html);
			$('.noucloudfiles-sidebar, .noucloudfiles-splitter, #wpbody .wrap').wrapAll('<div class="wrap-all"></div>');
			$('.upload-php table.media thead td#cb').before('<th class="noucloudfiles-move-header"></th>');
			$('.upload-php table.media #the-list th.check-column').before('<td class="noucloudfiles-move" title="' + noucloudfiles_params.dragdrop + '"><span class="uk-margin-small-right uk-icon" uk-icon="move"></span></td>');
			init_table();
		}

		function init_table(){
			var noucloudfilesMinWidth = 240;
			var noucloudfilesMaxWidth = 800;

			$(".panel-left").nouCloudFilesResizable({
				handleSelector: ".noucloudfiles-splitter",
				resizeHeight: false,
				onDrag: function (e, $el, newWidth, newHeight, opt) {
					// limit box size

					var x = e.pageX - $el.offset().left;

					if (newWidth < noucloudfilesMinWidth) {

						if (x > noucloudfilesMinWidth - 40) {

							return false;

						}

						$el.css('max-width', '0');

						$el.css('overflow', 'hidden');

						$('.noucloudfiles-sidebar_fixed').css('max-width', '0');
						$('.noucloudfiles-sidebar_fixed').css('overflow', 'hidden');
						var $wrapAll = $('.wrap-all');
						$wrapAll.addClass('show-expand');
						if (!$('.wrap-all >  span').length) {
							$('.wrap-all').prepend("<span class='noucloudfiles-expand'></span>");
						}
						setTimeout(function () {
							$('.noucloudfiles-expand').show();
						}, 600);


						$('.noucloudfiles-expand').on('click', function () {

							$(this).hide();
							$('.noucloudfiles-sidebar').css({
								'max-width': '800px',
								'width': noucloudfilesMinWidth + 5 + 'px'
							});
							$('.noucloudfiles-sidebar_fixed').css({
								'max-width': '800px',
								'width': noucloudfilesMinWidth + 5 + 'px'
							});
							$('.noucloudfiles-splitter').show();
							$wrapAll.removeClass('show-expand');

						});

						return false;

					} else if (newWidth > noucloudfilesMinWidth && $el.width > 0) {


						$el.css('overflow', 'initial');
					}

					if (newWidth >= noucloudfilesMaxWidth) {

						return false;
					}
				}
			});

			tree = $('#update-folders');
			tree.jstree({
				'core': {
					'data': {
						'url': function (node) {
							if (node.id == '#') {
								return noucloudfiles_params.ajax_url;
							}
							var params = '?action=noucloudfiles_get_folders';
							params += '&operation=get_content';
							params += '&_wpnonce=' + noucloudfiles_params.ajax_nonce;
							params += '&provider=' + node.original.provider;
							params += '&id=';
							return noucloudfiles_params.ajax_url + params;
						},
						'data': function (node) {
							var id = '';
							var provider = '';
							if (node.id != '#') {
								id = node.id;
							}
							if (node.provider) {
								provider = node.provider;
							}

							return {
								'action': 'noucloudfiles_get_folders',
								'operation': 'get_node',
								'_wpnonce': noucloudfiles_params.ajax_nonce,
								'id': id,
								'provider': provider,
								'text': node.text ? node.text : '',
								'data': node.data ? node.data : []
							};
						},
						'dataType': "json"
					},
					'check_callback': function (o, n, p, i, m) {

						if (m && m.dnd && m.pos !== 'i') { return false; }
						if (o === "move_node" || o === "copy_node") {
							if (this.get_node(n).parent === this.get_node(p).id) {
								return false;
							}

							if (this.get_node(n).original.provider !== this.get_node(p).original.provider) {
								return false;
							}
						}
						return true;
					},
					'themes': {
						'responsive': false,
						"icons": true
					},
					"multiple": false
				},
				'contextmenu': {
					'items': function (node) {
						var tmp = $.jstree.defaults.contextmenu.items();

						tmp.create.label = noucloudfiles_params.context_menu_create;
						tmp.create.action = function (data) {
							UIkit.modal($('#modal-create-folder')).show();
						}

						tmp.rename.label = noucloudfiles_params.context_menu_rename;
						tmp.remove.label = noucloudfiles_params.context_menu_remove;

						delete tmp.ccp;
						
						if(node.original.provider !== 'local'){
							tmp.sync = {
								"separator_before"	: false,
								"icon"				: false,
								"separator_after"	: false,
								"_disabled"			: false,
								"label"				: noucloudfiles_params.title_sync,
								"action"			: function (data) {
									var inst = $.jstree.reference(data.reference),
									obj = inst.get_node(data.reference);

									Noty.closeAll();
									var n = new Noty({
										text: noucloudfiles_params.title_continue_sync,
										layout: 'topCenter',
										theme: 'sunset',
										type: 'information',
										animation: {
											open: 'animated bounceInDown', // Animate.css class names
											close: 'animated bounceOutUp' // Animate.css class names
										},
										buttons: [
											Noty.button(noucloudfiles_params.title_sync, 'uk-button uk-button-danger uk-button-small', function () {
												var ajax_data = {
													...obj.original,
													action: 'noucloudfiles_get_folders',
													operation: 'sync_node',
													_wpnonce: noucloudfiles_params.ajax_nonce
												};
												change_folder(ajax_data);
												n.close();
											}),
											Noty.button(noucloudfiles_params.button_cancel, 'uk-margin-small-left uk-button uk-button-small', function () {
												n.close();
											})
										]
									});
									n.show();
									
								}
							}
						}
						
						return tmp;
					}
				},
				'types': {
					'default': { 'icon': 'dashicons dashicons-category' },
					'folder': { 'icon': 'dashicons dashicons-category' },
					'file': { 'valid_children': [], 'icon': 'dashicons dashicons-media-text' }
				},
				'unique': {
					'duplicate': function (name, counter) {
						return name + ' ' + counter;
					}
				},
				'plugins' : ['state','dnd','types','contextmenu','unique']
			})
				.on('rename_node.jstree', function (e, data) {
					var data = {
						...data.node.original,
						new_name: data.text,
						action: 'noucloudfiles_get_folders',
						operation: 'rename_node',
						_wpnonce: noucloudfiles_params.ajax_nonce
					};
					change_folder(data);
				})
				.on('move_node.jstree', function (e, data) {
					var ajax_data = {
						...data.node.original,
						parent: data.parent,
						old_parent: data.old_parent,
						action: 'noucloudfiles_get_folders',
						operation: 'move_node',
						_wpnonce: noucloudfiles_params.ajax_nonce
					};
					change_folder(ajax_data);
				})
				.on('changed.jstree', function (e, data) {
					e.preventDefault();
					if (data && data.selected && data.selected.length) {
						var node = data.node;
						var params = '?action=noucloudfiles_get_folders';
						params += '&operation=get_content';
						params += '&_wpnonce=' + noucloudfiles_params.ajax_nonce;
						params += '&provider=' + node.original.provider;
						params += '&id=' + data.selected.join(',');

						$('.noucloudfiles-main_add_new').removeAttr('disabled');
						
						if(node.original.provider !== 'local'){
							$('.js__noucloudfiles-sync').removeAttr('disabled');
						}else{
							$('.js__noucloudfiles-sync').attr('disabled', 'disabled');
						}

						var providers = noucloudfiles_params.providers;
						if (providers.indexOf(data.selected[0]) != -1) {
							$('.js__noucloudfiles-rename').attr('disabled', 'disabled');
							$('.js__noucloudfiles-delete').attr('disabled', 'disabled');
						} else {
							$('.js__noucloudfiles-rename').removeAttr('disabled');
							$('.js__noucloudfiles-delete').removeAttr('disabled');
						}
						node_selected = data;

					} else {
						$('.noucloudfiles-main_add_new').attr('disabled', 'disabled');
						$('.js__noucloudfiles-sync').attr('disabled', 'disabled');
						$('.js__noucloudfiles-rename').attr('disabled', 'disabled');
						$('.js__noucloudfiles-delete').attr('disabled', 'disabled');
						node_selected = null;
					}
					dragdropFile();
				})
				.on('select_node.jstree', function (e, data, selected) {
					if (data.event !== undefined && data.event.type === 'click') {
						
						if (noucloudfiles_params.media_mode != 'list') {
							dragdropFile();
							$('.upload-php #wp-media-grid').find('.attachment-filters option:selected').prop('selected', false).trigger('change');
						}

						var node = data.node;
						var term_id = node.id;
						if (typeof term_id === "undefined") {
							setCookie('noucloudfiles_last_access_folder_' + noucloudfiles_params.site_url, JSON.stringify({}), 365);
						} else {
							setCookie('noucloudfiles_last_access_folder_' + noucloudfiles_params.site_url, JSON.stringify(node.original), 365);
						}
						
						if (node.original.provider !== node.original.id) {
							// Select the filter folder
							var SelectedNode = get_folder_selected(term_id);
							set_breadcrumb(SelectedNode);

							$('.upload-php #' + node.original.provider + '-media-category').val(term_id).trigger('change');
							$('.upload-php #posts-filter .actions select option').removeAttr('selected');
							$('.upload-php #' + node.original.provider + '-media-category option[value="' + term_id + '"]').prop('selected', true);
							
							if (noucloudfiles_params.media_mode == 'list') {
								$loading.show();
								setTimeout(function () {
									$('#posts-filter').submit();
								}, 100);
							} else {
								if (noucloudfiles_params.is_upload_page === '0') {
									$('body .media-frame .media-frame-content').find('select option:selected').prop('selected', false).trigger('change');
									$('body .media-frame .media-frame-content').find('#' + node.original.provider + '-media-category').val(term_id).trigger('change');
									$('body .media-frame .media-frame-content').find('.noucloudfiles-filters-dropdown').remove();
									$('body .media-frame .media-frame-content').find('.media-attachments-filter-heading').append(generateDropdown($('body .media-frame .media-frame-content').find('.media-attachments-filter-heading')));
								}else{
									$('.upload-php #wp-media-grid').find('.attachment-filters option:selected').prop('selected', false).trigger('change');
									$('.upload-php #wp-media-grid').find('#' + node.original.provider + '-media-category').val(term_id).trigger('change');
									$('.upload-php').find('.noucloudfiles-filters-dropdown').remove();
									$('.upload-php #wp-media-grid').find('.media-frame-content .media-toolbar-secondary').append(generateDropdown($('.upload-php #wp-media-grid')));
									generate_breadcrumb();
								}
							}
						}
					}
				})
				.on('ready.jstree', function (e, data) {

					if (data.instance && data.instance._model && data.instance._model.data) {
						localStorage.setItem('noucloudfiles_folders', JSON.stringify(data.instance._model.data));
					}

					dragdropFile();

					if ($('.upload-php').find('#noucloudfiles-breadcrumb').length === 0) {
						if (noucloudfiles_params.media_mode !== 'list') {
							$('.upload-php').find('.attachments-browser ul.attachments').before('<ul id="noucloudfiles-breadcrumb"></ul>');
						} else {
							$('.upload-php').find('.tablenav.top').before('<ul id="noucloudfiles-breadcrumb"></ul>');
						}
					}

					generate_breadcrumb();

					if (noucloudfiles_params.media_mode == 'list') {
						$('.upload-php #posts-filter').find('.filter-items').append(generateDropdown($('.upload-php #posts-filter')));
					} else {
						$('.upload-php #wp-media-grid').find('.media-frame-content .media-toolbar-secondary').append(generateDropdown($('.upload-php #wp-media-grid')));
					}
				})
				.on('refresh_node.jstree', function (e, data) {
					dragdropFile();
				})
				.on('after_open.jstree', function (e, data) {
					dragdropFile();
				});
		}

		function dragdropFile(){
			var append_element = $('.upload-php #update-folders'),
			dragging_element = $('.noucloudfiles-move'),
			accept_element = '.noucloudfiles-move';
			if(noucloudfiles_params.media_mode !== 'list'){
				dragging_element = $('#wp-media-grid .attachments .attachment');
				accept_element = '.attachment';
				if (noucloudfiles_params.is_upload_page === '0') {
					dragging_element = $('body .media-frame-content .attachments .attachment');
					append_element = $('body .media-frame-content #update-folders');
				}
			}

			append_element.find('.jstree-anchor').droppable({
				hoverClass: "noucloudfiles-hover-folder",
				tolerance: 'pointer',
				accept: accept_element,
				over: function over(event, ui) {
					$(event.target).addClass("noucloudfilesdropzoom");
					$('.noucloudfiles-file-handle').addClass("overfolder");
				},
				out: function out(event, ui) {
					$(event.target).removeClass("noucloudfilesdropzoom");
					$('.noucloudfiles-file-handle').removeClass("overfolder");
				},
				drop: function drop(event, ui) {
					var dataObjects = get_data_folders();
					var self = $(this)[0];
					var parentId = '';
					if(self.id){
						parentId = self.id;
					}else{
						parentId = self.context.id;
					}

					var	term_id = parentId.replace("_anchor", ""),
						post_id = [],
						provider = dataObjects[term_id].original.provider;

					$(dragging_elements).each(function () {
						if (noucloudfiles_params.media_mode === 'grid') {
							if(post_id.indexOf($(ui.draggable[0]).data('id')) === -1) {
								post_id.push($(ui.draggable[0]).data('id'));
							}
						}else{
							var attrId = $(ui.draggable[0]).closest('tr').attr('id');
							var id = attrId.replace('post-', '');
							if(post_id.indexOf(id) === -1) {
								post_id.push(id);
							}
						}
					});

					var data = {
						post_id: post_id.join(','),
						term_id: term_id,
						provider: provider,
						action: 'noucloudfiles_get_folders',
						operation: 'move_file_to_folder',
						_wpnonce: noucloudfiles_params.ajax_nonce
					};
					change_folder(data);
				}
			});

			// .draggable
			dragging_element.draggable({
				helper: function helper(ui) {
					var parentId = ui.currentTarget.parentNode.id,
						id = parentId.replace("post-", "");
					if (noucloudfiles_params.media_mode === 'list' && $(ui.currentTarget).is('td')) {
						return '<div data-id="' + id + '" class="noucloudfiles-dragging-list">' + noucloudfiles_params.move_file_text + '</div>';
					} else {
						return $(ui.currentTarget).clone();
					}
				},
				cursor: 'move',
				appendTo: append_element,
				delay: 100, // Prevent dragging when only trying to click
				distance: 10,
				cursorAt: { top: 0, left: 0 },
				drag: function drag() { },
				start: function start(event, ui) {
					// Save the element we drag in a variable to use this later
					if(dragging_elements.indexOf(this) === -1) {
						dragging_elements.push(this);
					}
					// Add the original size of element
					$(ui.helper).css('width', $(ui.helper.context).outerWidth() + 'px');
					$(ui.helper).css('height', $(ui.helper.context).outerWidth() + 'px');
					
					if (noucloudfiles_params.media_mode === 'grid') {
						$('.upload-php').find('ul.attachments .attachment.selected').each(function () {
							if(dragging_elements.indexOf(this) === -1) {
								dragging_elements.push(this);
							}
						});
					}else{
						$('.upload-php #the-list input[name="media[]"]:checked').closest('tr').find('td.noucloudfiles-move').each(function () {
							if(dragging_elements.indexOf(this) === -1) {
								dragging_elements.push(this);
							}
						});
					}

					// Add some style to original elements
					$(dragging_elements).each(function () {
						$(this).addClass('noucloudfiles-dragging');
					});

					// Remove the checkbox of the attachment
					ui.helper.find('button.check').remove();

					// Add the number of elements dragged if more than 1
					if (dragging_elements.length > 1) {
						ui.helper.append('<div class="noucloudfiles-drag-count">' + dragging_elements.length + '</div>');
					}
					
				},
				stop: function stop(event, ui) {
					// Revert style
					$(dragging_elements).each(function () {
						$(this).removeClass('noucloudfiles-dragging');
					});
					dragging_elements = [];
				}
			});
		}
		
		dragdropFile();

		function set_folder_selected(id) {
			tree.jstree(true).select_node(id);
		}

		function get_folder_selected(id) {
			var ref = tree.jstree(true),
				sel = ref.get_node(id);
			return sel;
		}

		$('body').on('click', '.media-modal .delete-attachment, .delete-selected-button', function(){
			setTimeout(() => {
				tree.jstree(true).refresh();
			}, 200);
		});

		/**
		 * Build breadcrumb
		*/
		function queryString(key) {
			key = key.replace(/[*+?^$.\[\]{}()|\\\/]/g, "\\$&"); // escape RegEx meta chars
			var match = location.search.match(new RegExp("[?&]" + key + "=([^&]+)(&|$)"));
			return match && decodeURIComponent(match[1].replace(/\+/g, " "));
		}

		if ($('.upload-php').length === 0) {
			localStorage.setItem('noucloudfiles_breadcrumb_folders', JSON.stringify([]));
			localStorage.setItem('jstree', null);
		} else {
			if (noucloudfiles_params.media_mode != 'list') {
				if (queryString('noucloudfiles_local_folder') !== null ||
					queryString('noucloudfiles_dropbox_folder') !== null ||
					queryString('noucloudfiles_google_drive_folder') !== null ||
					queryString('noucloudfiles_onedrive_folder') !== null) {
					//
				} else {
					localStorage.setItem('noucloudfiles_breadcrumb_folders', JSON.stringify([]));
					localStorage.setItem('jstree', null);
				}
			}
		}

		function set_breadcrumb(SelectedNode) {
			var breadcrumb = uiGetParents(SelectedNode);
			localStorage.setItem('noucloudfiles_breadcrumb_folders', JSON.stringify(breadcrumb));
		}

		function get_breadcrumb() {
			var enable = false;

			if (noucloudfiles_params.media_mode == 'list') {
				if (queryString('noucloudfiles_local_folder') !== null ||
					queryString('noucloudfiles_dropbox_folder') !== null ||
					queryString('noucloudfiles_google_drive_folder') !== null ||
					queryString('noucloudfiles_onedrive_folder') !== null) {
					enable = true;
				}
			} else {
				enable = true;
			}

			if (enable) {
				return JSON.parse(localStorage.getItem('noucloudfiles_breadcrumb_folders'));
			}
			localStorage.setItem('noucloudfiles_breadcrumb_folders', JSON.stringify([]));
			return false;
		}

		function generate_breadcrumb() {
			var breadcrumb_content = '';
			var noucloudfiles_breadcrumb = $('.upload-php').find('#noucloudfiles-breadcrumb');

			try {
				var current_breadcrumb = get_breadcrumb();
				if (current_breadcrumb) {
					$.each(current_breadcrumb, function (i, item) {
						breadcrumb_content += '<li class="filter-item" data-id="#' + item.provider + '-media-category" data-value="' + item.id + '">&nbsp;&nbsp;/&nbsp;&nbsp;<a href="#">' + item.text + '</a></li>';
					});
				}
			} catch ($error) {
				//
				console.log($error);
			}

			breadcrumb_content = '<li class="clear_filters"><span>' + noucloudfiles_params.youarehere + '</span>&nbsp;&nbsp;:<a href="' + noucloudfiles_params.media_url + '" data-id="0">&nbsp;&nbsp;' + noucloudfiles_params.home + '&nbsp;&nbsp;</a></li>' + breadcrumb_content;
			// Finally update breadcrumb content
			noucloudfiles_breadcrumb.html(breadcrumb_content);
		}
		function uiGetParents(loSelectedNode) {
			var list = [];
			try {
				var lnLevel = loSelectedNode.parents.length;
				var lsSelectedID = loSelectedNode.id;
				var loParent = $("#" + lsSelectedID);
				var provider = loSelectedNode.original.provider;
				list.push({
					'id': loSelectedNode.id,
					'text': loSelectedNode.text,
					'provider': provider
				});

				for (var ln = 0; ln <= lnLevel - 1; ln++) {
					var loParent = loParent.parent().parent();
					if (loParent.children()[1] != undefined) {
						list.push({
							'id': (loParent.children()[1].id.replace("_anchor", "")),
							'text': loParent.children()[1].text,
							'provider': provider
						});
					}
				}
				list.reverse();
			}
			catch (err) {
				localStorage.setItem('noucloudfiles_breadcrumb_folders', JSON.stringify([]));
			}

			return list;
		}

		/**
         * Select a filter and trigger change
         * @param filter_elem
         * @param value
         */
		function noucloudfilesSelectFilter(filter_elem, value) {
			// Save current value in case of undo

			if($('body').find('#menu-item-browse').length > 0){
				$('body').find('.attachments-browser').find('select option:selected').prop('selected', false).trigger('change');
				$(filter_elem).val(value).trigger('change');
				$('body').find('.attachments-browser .media-attachments-filter-heading').find('.noucloudfiles-filters-dropdown').remove();
				$('body').find('.attachments-browser .media-attachments-filter-heading').append(generateDropdown($('body .attachments-browser .media-toolbar-secondary')));
			}else{
				tree.jstree(true).deselect_all();
				set_folder_selected(value);

				if (noucloudfiles_params.media_mode != 'list') {
					$('.upload-php #wp-media-grid').find('.attachment-filters option:selected').prop('selected', false).trigger('change');
				}

				$(filter_elem).val(value).trigger('change');

				var SelectedNode = get_folder_selected(value);
				set_breadcrumb(SelectedNode);

				if (noucloudfiles_params.media_mode == 'list') {
					$loading.show();
					setTimeout(function () {
						$('#posts-filter').submit();
					}, 100);
				}

				$('.upload-php').find('.noucloudfiles-filters-dropdown').remove();

				if (noucloudfiles_params.media_mode == 'list') {
					$('.upload-php #posts-filter').find('.filter-items').append(generateDropdown($('.upload-php #posts-filter')));
				} else {
					$('.upload-php #wp-media-grid').find('.media-frame-content .media-toolbar-secondary').append(generateDropdown($('.upload-php #wp-media-grid')));
					generate_breadcrumb();
				}
			}

			return false;
		}

		$('body').on('click', '.filter-item', function () {
			noucloudfilesSelectFilter($(this).data('id'), $(this).data('value'));
			return false;
		});

		$('body').on('click', '.clear_filters', function () {
			if($('body').find('#menu-item-browse').length > 0){
				$('body').find('.attachments-browser').find('select option:selected').prop('selected', false).trigger('change');
				$('body').find('.noucloudfiles-filters-dropdown-list').removeClass('active');
				localStorage.setItem('noucloudfiles_breadcrumb_folders', JSON.stringify([]));
			}else{
				$loading.show();
				tree.jstree(true).deselect_all();
				localStorage.setItem('noucloudfiles_breadcrumb_folders', JSON.stringify([]));
				setTimeout(function () {
					location.replace(noucloudfiles_params.media_url);
				}, 300);
			}
			return false;
		});

		$('body').on('click', '.noucloudfiles-filters-dropdown-button', function () {
			$('body').find('.noucloudfiles-filters-dropdown-list').toggleClass("active");
		});

		// Click outside the dropdown to close it
		$(window).on('click', function (event) {
			if ($(event.target).hasClass('noucloudfiles-filters-dropdown-button')) {
				return;
			}
			$('body').find('.noucloudfiles-filters-dropdown-list').removeClass('active');
		});

		/*
		* End init
		*/

		$("#folder-form").on('submit', function(e){
			e.preventDefault();
			
			if (node_selected == null) {
				noucloudfiles_noti("<span uk-icon='icon: warning'></span> " + noucloudfiles_params.popup_error_select_node, 'error');
				return false;
			}

			var name = $('#folder-form input').val();
			if (name == '') {
				$('#folder-form input').addClass('uk-form-danger');
				noucloudfiles_noti("<span uk-icon='icon: warning'></span> " + noucloudfiles_params.popup_error_create_folder, 'error');
				return false;
			}

			var data = {
				provider: node_selected.node.original.provider,
				parent: node_selected.node.original.id,
				taxonomy: node_selected.node.original.taxonomy,
				name: name,
				action: 'noucloudfiles_create_folder',
				_wpnonce: noucloudfiles_params.ajax_nonce
			};

			create_folder(data);
		});

		$('#folder-form button.create').on('click', function (event) {
			event.preventDefault();

			if (node_selected == null) {
				noucloudfiles_noti("<span uk-icon='icon: warning'></span> " + noucloudfiles_params.popup_error_select_node, 'error');
				return false;
			}

			var name = $('#folder-form input').val();
			if (name == '') {
				$('#folder-form input').addClass('uk-form-danger');
				noucloudfiles_noti("<span uk-icon='icon: warning'></span> " + noucloudfiles_params.popup_error_create_folder, 'error');
				return false;
			}

			var data = {
				provider: node_selected.node.original.provider,
				parent: node_selected.node.original.id,
				taxonomy: node_selected.node.original.taxonomy,
				name: name,
				action: 'noucloudfiles_create_folder',
				_wpnonce: noucloudfiles_params.ajax_nonce
			};

			create_folder(data);
		});

		function change_folder(data) {
			$.ajax({
				url: noucloudfiles_params.ajax_url,
				type: "POST",
				data: data,
				beforeSend: function () {
					$loading.show();
				},
				success: function (result) {
					result = JSON.parse(result);
					if (result.status == 'success') {
						noucloudfiles_noti("<span uk-icon='icon: check'></span> " + result.message, 'success');
						if(data.operation === 'sync_node' || data.operation === 'delete_node'){
							if (noucloudfiles_params.is_upload_page !== '0') {
								location.reload();
							}
						}else{
							tree.jstree(true).refresh();
							if(data.provider === 'local'){
								render_dropdown_media_folder();
							}
						}

					} else {
						noucloudfiles_noti("<span uk-icon='icon: warning'></span> " + result.message, 'error');
					}
					generate_breadcrumb();
					$loading.hide();
				},
				error: function (jqXHR, textStatus, errorThrown) {
					noucloudfiles_noti("<span uk-icon='icon: warning'></span> " + errorThrown, 'error');
				}
			});
		}

		function create_folder(data) {
			$.ajax({
				url: noucloudfiles_params.ajax_url,
				type: "POST",
				data: data,
				beforeSend: function () {
					$loading.show();
				},
				success: function (result) {
					if (result.data.status == 'success') {
						tree.jstree(true).refresh();
						if(data.provider === 'local'){
							render_dropdown_media_folder();
						}
						noucloudfiles_noti("<span uk-icon='icon: check'></span> " + result.data.message, 'success');
					} else {
						noucloudfiles_noti("<span uk-icon='icon: warning'></span> " + result.data.message, 'error');
					}

					UIkit.modal($('#modal-create-folder')).hide();
					$loading.hide();
				},
				error: function (jqXHR, textStatus, errorThrown) {
					noucloudfiles_noti("<span uk-icon='icon: warning'></span> " + errorThrown, 'error');
				}
			});
		}

		function render_dropdown_media_folder(){
			if ($('body').find('.post-upload-ui .max-upload-size').length > 0) {
				$.ajax({
					url: noucloudfiles_params.ajax_url,
					type: "GET",
					data: {
						action: 'noucloudfiles_dropdown_folder_media_library',
						_wpnonce: noucloudfiles_params.ajax_nonce	
					},
					success: function (result) {
						if (result.data.status == 'success') {
							if ($('body').find('#local-media-category-upload').length > 0) {
								$('body').find('#local-media-category-upload').remove();
							}
							$('body').find('.post-upload-ui .max-upload-size').before(result.data.html);
						}
					},
					error: function (jqXHR, textStatus, errorThrown) {
						noucloudfiles_noti("<span uk-icon='icon: warning'></span> " + errorThrown, 'error');
					}
				});
			}
		}

		$('body').on('click', '.js__noucloudfiles-rename', function () {
			var ref = tree.jstree(true),
				sel = ref.get_selected(true);
			if (!sel.length) { return false; }
			sel = sel[0];
			ref.edit(sel);
		});

		$('body').on('click', '.js__noucloudfiles-delete', function () {
			var ref = tree.jstree(true),
				sel = ref.get_selected(true);
			if (!sel.length) { return false; }
			Noty.closeAll();
			var n = new Noty({
				text: noucloudfiles_params.title_continue_delete,
				layout: 'topCenter',
				theme: 'sunset',
				type: 'error',
				animation: {
					open: 'animated bounceInDown', // Animate.css class names
					close: 'animated bounceOutUp' // Animate.css class names
				},
				buttons: [
					Noty.button(noucloudfiles_params.title_delete, 'uk-button uk-button-primary uk-button-small', function () {
						var data = {
							...sel[0].original,
							action: 'noucloudfiles_get_folders',
							operation: 'delete_node',
							_wpnonce: noucloudfiles_params.ajax_nonce
						};
						change_folder(data);
						n.close();
						ref.delete_node(sel);
					}),
					Noty.button(noucloudfiles_params.button_cancel, 'uk-margin-small-left uk-button uk-button-small', function () {
						n.close();
					})
				]
			  });
			n.show();
		});

		$('.noucloudfiles-authorize-button').on('click', function () {
			var client = $(this).val();
			var data = {
				client: client,
				action: 'noucloudfiles_create_authorize_url',
				_wpnonce: noucloudfiles_params.ajax_nonce
			};
			$.ajax({
				url: noucloudfiles_params.ajax_url,
				type: "POST",
				data: data,
				beforeSend: function () {
					$loading.show();
				},
				success: function (result) {
					if (result.data.status == 'success') {
						location.replace(result.data.authorize_url);
					} else {
						noucloudfiles_noti("<span uk-icon='icon: warning'></span> " + result.data.message, 'error');
					}
					$loading.hide();
				},
				error: function (jqXHR, textStatus, errorThrown) {
					noucloudfiles_noti("<span uk-icon='icon: warning'></span> " + errorThrown, 'error');
				}
			});
		});


		$('.wrap.noucloudfiles').on('click', '.custom-synchronization', function () {
			var self = $(this),
				type = $(this).data('sync'),
				taxonomy = $(this).data('taxonomy'),
				provider = $(this).data('provider'),
				toggle_id = $('#toggle_' + provider);

			self.attr('disabled', 'disabled');

			toggle_id.jstree({
				'core': {
					'data': {
						'url': function (node) {
							if (node.id == '#') {
								return noucloudfiles_params.ajax_url;
							}
							var params = '?action=noucloudfiles_get_folders';
							params += '&operation=get_folder_cloud';
							params += '&_wpnonce=' + noucloudfiles_params.ajax_nonce;
							params += '&provider=' + provider;
							params += '&id=';
							return noucloudfiles_params.ajax_url + params;
						},
						'data': function (node) {
							var id = '';
							if (node.id != '#') {
								id = node.id;
							}

							return {
								'action': 'noucloudfiles_get_folders',
								'operation': 'get_folder_cloud',
								'_wpnonce': noucloudfiles_params.ajax_nonce,
								'id': id,
								'provider': provider,
								'text': node.text ? node.text : '',
								'data': node.data ? node.data : []
							};
						},
						'dataType': "json"
					},
					'themes': {
						'responsive': false,
						"icons": true
					},
					"multiple": true
				},
				'types': {
					'default': { 'icon': 'dashicons dashicons-category' },
					'folder': { 'icon': 'dashicons dashicons-category' },
					'file': { 'valid_children': [], 'icon': 'dashicons dashicons-media-text' }
				},
				'plugins': ['state', 'types']
			})
				.on('loaded.jstree', function (e, data) {
					e.preventDefault();
					self.addClass('hidden');
				})
				.on('changed.jstree', function (e, data) {
					e.preventDefault();
					if (data && data.selected && data.selected.length) {
						$('#run_synchronization_' + data.node.original.provider).removeClass('hidden');
					} else {
						$('#run_synchronization_' + provider).addClass('hidden');
					}
				});
		});

		function get_sync_child(ref, item){
			var child = [];
			if(item.children.length > 0){
				$.each(item.children, function (i, item) {
					var sel = ref.get_node(item);
					child.push({
						id: sel.original.id,
						text: sel.original.text,
						data: (sel.data ? sel.data : []),
						provider: sel.original.provider,
						parent: (sel.original && sel.original.parent ? sel.original.parent : ''),
						children: get_sync_child(ref, sel)
					});
				});
			}

			return child;
		}

		$('.wrap.noucloudfiles').on('click', '.synchronization', function () {
			var type = $(this).data('sync'),
				taxonomy = $(this).data('taxonomy'),
				provider = $(this).data('provider'),
				toggle_id = $('#toggle_' + provider);

			var data_selected = [];

			if (type == 'full') {
				data_selected.push({
					id: provider,
					provider: provider,
					parent: '',
					children: []
				});
			} else {
				var ref = toggle_id.jstree(true),
					sel = ref.get_selected(true);
				$.each(sel, function (i, item) {
					var child = [];
					if(item.children.length > 0){
						$.each(item.children, function (i, item) {
							sel = ref.get_node(item);
							child.push({
								id: sel.original.id,
								text: sel.original.text,
								data: (sel.data ? sel.data : []),
								provider: sel.original.provider,
								parent: (sel.original && sel.original.parent ? sel.original.parent : ''),
								children: get_sync_child(ref, sel)
							});
						});
					}
					data_selected.push({
						id: item.original.id,
						text: item.original.text,
						data: (item.data ? item.data : []),
						provider: item.original.provider,
						parent: (item.original && item.original.parent ? item.original.parent : ''),
						children: child
					});
				});
			}

			var data = {
				provider: provider,
				selected: JSON.stringify(data_selected),
				action: 'noucloudfiles_sync_folders',
				_wpnonce: noucloudfiles_params.ajax_nonce
			};
			
			$.ajax({
				url: noucloudfiles_params.ajax_url,
				type: "POST",
				data: data,
				beforeSend: function () {
					$loading.show();
				},
				success: function (result) {
					if (result.data.status == 'success') {
						noucloudfiles_noti("<span uk-icon='icon: check'></span> " + result.data.message, 'success');
					} else {
						noucloudfiles_noti("<span uk-icon='icon: warning'></span> " + result.data.message, 'error');
					}
					$loading.hide();
				},
				error: function (jqXHR, textStatus, errorThrown) {
					noucloudfiles_noti("<span uk-icon='icon: warning'></span> " + errorThrown, 'error');
				}
			});
		});

		$('body').on('click', '.js__noucloudfiles-sync', function () {
			var ref = tree.jstree(true),
				sel = ref.get_selected(true);
			if (!sel.length) { return false; }
			Noty.closeAll();
			var n = new Noty({
				text: noucloudfiles_params.title_continue_sync,
				layout: 'topCenter',
				theme: 'sunset',
				type: 'information',
				animation: {
					open: 'animated bounceInDown', // Animate.css class names
					close: 'animated bounceOutUp' // Animate.css class names
				},
				buttons: [
					Noty.button(noucloudfiles_params.title_sync, 'uk-button uk-button-danger uk-button-small', function () {
						var ajax_data = {
							...sel[0].original,
							action: 'noucloudfiles_get_folders',
							operation: 'sync_node',
							_wpnonce: noucloudfiles_params.ajax_nonce
						};
						change_folder(ajax_data);
						n.close();
					}),
					Noty.button(noucloudfiles_params.button_cancel, 'uk-margin-small-left uk-button uk-button-small', function () {
						n.close();
					})
				]
			  });
			n.show();
		});

		$(".upload-php #wpcontent").on("dragover", function(e) {
			e.preventDefault();
			e.stopPropagation();
			var ref = tree.jstree(true),
				sel = ref.get_selected(true);
			if (sel.length > 0) { 
				if(sel[0].original.provider !== sel[0].original.id){
					$(".js-upload-to-folder").show();
					folder_selected = sel[0];
				}
			}
		});

		$("html").on("drop", function(e) { 
			e.preventDefault(); 
			e.stopPropagation(); 
			$(".js-upload-to-folder").hide();
			$loading.show();
		});
	
		function add_media_tree(){
			var html = html_sidebar;
			$("#noucloudfiles-sidebar").remove();

			$("body").find('.media-frame .media-frame-content .noucloudfiles-sidebar').remove();
			$("body").find('.media-frame .media-frame-content .noucloudfiles-splitter').remove();

			$("body").find('.media-frame .media-frame-content .attachments-browser').before(html);
			$("body").find('.media-frame .media-frame-content .attachments-browser').addClass('appended');
			$("body").find('.media-frame .media-frame-content').addClass('wrap-all');
		}
		
		if ( typeof wp !== 'undefined' && wp.media && noucloudfiles_params.is_upload_page === '0'){
			wp.media.view.Modal.prototype.on('open', function(){  
				if($('body').find('.attachments-browser .media-attachments-filter-heading').length > 0){
					$('body').find('.attachments-browser .media-attachments-filter-heading').find('.noucloudfiles-filters-dropdown').remove();
					$('body').find('.attachments-browser .media-attachments-filter-heading').append(generateDropdown($('body .attachments-browser .media-toolbar-secondary')));
					add_media_tree();
					init_table();
				}else{
					$("body").find('.media-frame-content .noucloudfiles-sidebar').remove();
					$("body").find('.media-frame-content .noucloudfiles-splitter').remove();
					$('body').find('.attachments-browser .media-toolbar-secondary').find('.noucloudfiles-filters-dropdown').remove();
					$('body').find('.attachments-browser .media-toolbar-secondary').append(generateDropdown($('body .attachments-browser .media-toolbar-secondary')));
					add_media_tree();
					init_table();
				}
			});
			$('body').on('click', '#menu-item-browse', function(){
				if($('body').find('.attachments-browser .media-attachments-filter-heading').length > 0){
					$('body').find('.attachments-browser .media-attachments-filter-heading').find('.noucloudfiles-filters-dropdown').remove();
					$('body').find('.attachments-browser .media-attachments-filter-heading').append(generateDropdown($('body .attachments-browser .media-toolbar-secondary')));
					add_media_tree();
					init_table();
				}else{
					$('body').find('.attachments-browser .media-toolbar-secondary').find('.noucloudfiles-filters-dropdown').remove();
					$('body').find('.attachments-browser .media-toolbar-secondary').append(generateDropdown($('body .attachments-browser .media-toolbar-secondary')));
					add_media_tree();
					init_table();
				}
			});
		}

		const copyToClipboard = str => {
			const el = document.createElement('textarea');
			el.value = str;
			el.setAttribute('readonly', '');
			el.style.position = 'absolute';
			el.style.left = '-9999px';
			document.body.appendChild(el);
			el.select();
			document.execCommand('copy');
			document.body.removeChild(el);
		};

		$('body').on('click', '.forminp-url .url', function () {
			var val = $(this).val();
			copyToClipboard(val);
			noucloudfiles_noti("<span uk-icon='icon: check'></span> " + noucloudfiles_params.copy_to_clipboard, 'success');
		});
	});

	if (wpUploader) {
		$.extend(wpUploader.prototype, {
			init: function init() {
				// Add the current wpmf folder to the request
				this.uploader.bind('BeforeUpload', function () {
					var lastAccessFolder = getCookie('noucloudfiles_last_access_folder_' + noucloudfiles_params.site_url);
					var node = JSON.parse(lastAccessFolder);
					if ($('body').find('#local-media-category-upload').length > 0 && folder_selected === null) {
						this.settings.multipart_params['noucloudfiles_provider'] = 'local';
						this.settings.multipart_params['noucloudfiles_folder'] = (upload_folder !== null ? upload_folder : $('body').find('#local-media-category-upload').val());
					}

					if(node && node.id){
						console.log('BeforeUpload folder_selected', node);
						this.settings.multipart_params['noucloudfiles_provider'] = node.provider;
						this.settings.multipart_params['noucloudfiles_folder'] = node.id;
					}
				});

				// Reload attachments so they can show up if we're inside a folder
				this.uploader.bind('UploadComplete', function () {
					noucloudfiles_noti("<span uk-icon='icon: check'></span> " + noucloudfiles_params.upload_successfully_title, 'success');
					setTimeout(() => {
						location.reload();
					}, 4000);
				});
			}
		});
	}

	if (typeof wpUploaderInit !== 'undefined') {
		if(folder_selected === null){
			wpUploaderInit.multipart_params['noucloudfiles_provider'] = 'local';
			wpUploaderInit.multipart_params['noucloudfiles_folder'] = (upload_folder !== null ? upload_folder : $('body').find('#local-media-category-upload').val());
		}

		if(folder_selected !== null){
			wpUploaderInit.multipart_params['noucloudfiles_provider'] = folder_selected.original.provider;
			wpUploaderInit.multipart_params['noucloudfiles_folder'] = folder_selected.original.id;
		}
	}

})(jQuery);
