<?php

/**
 * The admin-specific functionality of the plugin.
 *
 * @link       https://themeforest.net/user/nouthemes/portfolio
 * @since      1.0.0
 *
 * @package    Cloudfiles_Wordpress_Media_Library_Folders_Cloud
 * @subpackage Cloudfiles_Wordpress_Media_Library_Folders_Cloud/admin
 */

/**
 * The admin-specific functionality of the plugin.
 *
 * Defines the plugin name, version, and two examples hooks for how to
 * enqueue the admin-specific stylesheet and JavaScript.
 *
 * @package    Cloudfiles_Wordpress_Media_Library_Folders_Cloud
 * @subpackage Cloudfiles_Wordpress_Media_Library_Folders_Cloud/admin
 * @author     Nouthemes <nguyenvanqui89@gmail.com>
 */
class Cloudfiles_Wordpress_Media_Library_Folders_Cloud_Admin {

	/**
	 * The ID of this plugin.
	 *
	 * @since    1.0.0
	 * @access   private
	 * @var      string    $plugin_name    The ID of this plugin.
	 */
	private $plugin_name;

	/**
	 * The version of this plugin.
	 *
	 * @since    1.0.0
	 * @access   private
	 * @var      string    $version    The current version of this plugin.
	 */
	private $version;
	private $active;

	/**
	 * Initialize the class and set its properties.
	 *
	 * @since    1.0.0
	 * @param      string    $plugin_name       The name of this plugin.
	 * @param      string    $version    The version of this plugin.
	 */
	public function __construct( $plugin_name, $version ) {
		$this->active = get_option('nou_cloudfiles_wordpress_media_license_active', 0);
		$this->plugin_name = $plugin_name;
		$this->version = $version;
	}

	public function in_admin_footer(){
		echo '<div id="cloudfiles_loading"><span class="uk-margin-small-right" uk-spinner="ratio: 3"></span></div>';
	}

	public function admin_settings_init(){
		Cloudfiles_Wordpress_Media_Library_Folders_Cloud_Admin_Settings::get_settings_pages();
		
		if( isset( $_POST['noucloudfiles_settings_nonce'] ) ) {
			Cloudfiles_Wordpress_Media_Library_Folders_Cloud_Admin_Settings::save();
		}
	}

	public function handle_settings(){
		if( isset( $_GET['authorize'] ) && $_GET['authorize'] == 1 ) {
			Cloudfiles_Wordpress_Media_Library_Folders_Cloud_Admin_Settings::add_message( esc_html__('Onedrive authorize successfuly.', 'cloudfiles-wordpress-media-library-folders-cloud') );
			
			if(!empty($_GET['tab'])){
				try{
					$provider = new Cloudfiles_Wordpress_Media_Library_Folders_Cloud_Pro($_GET['tab']);
					$provider->get_folder_cloud();
				} catch(Exception $e){
	
				}
			}
			
		}
	}

	public function onedrive_authorize_redirect(){
		
		if( !empty( $_GET['error'] ) && !empty($_GET['error_description']) ) {
			wp_die( 
				esc_html($_GET['error_description']),
				'',
				[
					'link_url' => esc_url(admin_url('admin.php?page=cloudfiles_wordpress_media_library_folders_cloud')),
					'link_text' => esc_html__('Back to Cloudfiles', 'cloudfiles-wordpress-media-library-folders-cloud'),
				] 
			);
		}

		if( !empty($_GET['code']) ) {
			global $pagenow;
			if ($pagenow == 'upload.php') {
				$provider = new Cloudfiles_Wordpress_Media_Library_Folders_Cloud_Provider_Onedrive_Business();
				$provider->createToken($_GET['code']);
			} else {
				$provider = new Cloudfiles_Wordpress_Media_Library_Folders_Cloud_Provider_Onedrive();
				$provider->createToken($_GET['code']);
			}
		}
	}

	/**
	 * Register the stylesheets for the admin area.
	 *
	 * @since    1.0.0
	 */
	public function enqueue_styles() {

		/**
		 * This function is provided for demonstration purposes only.
		 *
		 * An instance of this class should be passed to the run() function
		 * defined in Cloudfiles_Wordpress_Media_Library_Folders_Cloud_Loader as all of the hooks are defined
		 * in that particular class.
		 *
		 * The Cloudfiles_Wordpress_Media_Library_Folders_Cloud_Loader will then create the relationship
		 * between the defined hooks and the functions defined in this
		 * class.
		 */

		wp_enqueue_style( 'noty', plugin_dir_url( __FILE__ ) . 'css/noty.css', array(), $this->version, 'all' );
		wp_enqueue_style( 'animate', plugin_dir_url( __FILE__ ) . 'css/animate.min.css', array(), $this->version, 'all' );
		wp_enqueue_style( 'tooltipster', plugin_dir_url( __FILE__ ) . 'plugin/tooltipster/css/tooltipster.bundle.min.css', array(), $this->version, 'all' );
		wp_enqueue_style( 'tooltipster-themes', plugin_dir_url( __FILE__ ) . 'plugin/tooltipster/css/plugins/tooltipster/sideTip/themes/tooltipster-sideTip-borderless.min.css', array(), $this->version, 'all' );
		wp_enqueue_style( 'jstree', plugin_dir_url( __FILE__ ) . 'plugin/jstree/dist/themes/default/style.min.css', array(), $this->version, 'all' );
		wp_enqueue_style( $this->plugin_name, plugin_dir_url( __FILE__ ) . 'css/cloudfiles-wordpress-media-library-folders-cloud-admin.css', array(), $this->version, 'all' );
		wp_enqueue_style( "uikit", plugin_dir_url( __FILE__ ) . 'css/uikit.min.css', array(), $this->version, 'all' );

	}

	/**
	 * Gutenberg enqueues
	 *
	 * @since    1.0.0
	 */
	public function gutenberg_enqueue_block_editor_assets() {
		wp_enqueue_script(
			'document-embedder-blocks-js', // Unique handle.
			plugin_dir_url( __FILE__ ) . 'js/document-embedder-blocks.js',
			array( 'wp-blocks', 'wp-i18n', 'wp-element' ), // Dependencies, defined above.
			$this->version
		);

		wp_enqueue_style(
			'document-embedder-blocks-css', // Handle.
			plugin_dir_url( __FILE__ ) . 'css/document-embedder-blocks.css', // editor.css: This file styles the block within the Gutenberg editor.
			$this->version
		);
	}

	/**
	 * Register the JavaScript for the admin area.
	 *
	 * @since    1.0.0
	 */
	public function enqueue_scripts() {

		global $pagenow;
		/**
		 * This function is provided for demonstration purposes only.
		 *
		 * An instance of this class should be passed to the run() function
		 * defined in Cloudfiles_Wordpress_Media_Library_Folders_Cloud_Loader as all of the hooks are defined
		 * in that particular class.
		 *
		 * The Cloudfiles_Wordpress_Media_Library_Folders_Cloud_Loader will then create the relationship
		 * between the defined hooks and the functions defined in this
		 * class.
		 */
		
		// phpcs:disable WordPress.Security.NonceVerification.Recommended -- No action, nonce is not required
		$term_list = [];

		if($this->active == 1){
			foreach (CLOUDFILES_WORDPRESS_MEDIA_LIBRARY_FOLDERS_CLOUD_TANONOMIES as $tax) {
				$p = str_replace('noucloudfiles_tax_', '', $tax);
				$p = ($p == 'onedrive_b') ? CLOUDFILES_WORDPRESS_MEDIA_LIBRARY_FOLDERS_CLOUD_ONEDRIVE_BUSINESS : $p;
				$provider = new Cloudfiles_Wordpress_Media_Library_Folders_Cloud_Pro($p);
				if($provider->is_enable()){
					$selected = isset($_GET['noucloudfiles_'. $p .'_folder']) ? $_GET['noucloudfiles_'. $p .'_folder'] : 0;
					$dropdown_options = array(
						'show_option_none'  => false,
						'hide_empty'        => false,
						'hierarchical'      => true,
						'orderby'           => 'name',
						'taxonomy'          => $tax,
						'name'              => 'noucloudfiles_'. $p .'_folder',
						'id'                => $p.'-media-category',
						'selected'          => (int) $selected,
						'echo'              => 0,
						'show_count' 		=> true,
						'walker' 			=> new Cloudfiles_Wordpress_Media_Library_Folders_Cloud_Walker_Filter(),
						'value' 			=> 'id'
					);
					$attachment_terms = wp_dropdown_categories($dropdown_options);
					$attachment_terms = preg_replace(array("/<select([^>]*)>/", "/<\/select>/"), "", $attachment_terms);
					$term_list[$p] = [
						'all' => sprintf('%s %s', esc_html__('Folder', 'cloudfiles-wordpress-media-library-folders-cloud'), $provider->client->get_name()),
						'items' => json_decode("[".substr($attachment_terms, 2)."]", true)
					];
				}
			}
			// phpcs:enable
			
			$media_mode = get_user_option( 'media_library_mode', get_current_user_id() ) ? get_user_option( 'media_library_mode', get_current_user_id() ) : 'grid';
			if ($pagenow !== 'upload.php') {
				$media_mode = 'grid';
			}

			wp_enqueue_script('jquery-ui-draggable');
			wp_enqueue_script('jquery-ui-droppable');
			
			wp_enqueue_script( 'uikit', plugin_dir_url( __FILE__ ) . 'js/uikit.min.js', array( 'jquery' ), $this->version, true );
			wp_enqueue_script( 'noty', plugin_dir_url( __FILE__ ) . 'js/noty.min.js', array( 'jquery' ), $this->version, true );
			wp_enqueue_script( 'uikit-icons', plugin_dir_url( __FILE__ ) . 'js/uikit-icons.min.js', array( 'jquery' ), $this->version, true );
			wp_enqueue_script( 'jquery-resizable', plugin_dir_url( __FILE__ ) . 'js/jquery-resizable.js', array( 'jquery' ), $this->version, true );
			wp_enqueue_script( 'tooltipster', plugin_dir_url( __FILE__ ) . 'plugin/tooltipster/js/tooltipster.bundle.min.js', array( 'jquery' ), $this->version, true );
			wp_enqueue_script( 'jstree', plugin_dir_url( __FILE__ ) . 'plugin/jstree/dist/jstree.min.js', array( 'jquery' ), $this->version, true );
			
			wp_enqueue_script( 'cloudfiles-folder-filter', plugin_dir_url( __FILE__ ) . 'js/folder-filter.js', array( 'jquery' ), $this->version, true );
			
			wp_enqueue_script( $this->plugin_name, plugin_dir_url( __FILE__ ) . 'js/cloudfiles-wordpress-media-library-folders-cloud-admin.js', array( 'jquery' ), $this->version, true );
			
			wp_localize_script( 'uikit', 'noucloudfiles_params', array(
				'site_url'              				=> site_url(),
				'ajax_url' 								=> esc_url( admin_url( 'admin-ajax.php' ) ),
				'ajax_nonce' 							=> wp_create_nonce( 'noucloudfiles_params_nonce' ),
				'title_delete' 							=> esc_html__('Delete', 'cloudfiles-wordpress-media-library-folders-cloud'),
				'title_continue_delete' 				=> esc_html__('Do you want to delete folder?', 'cloudfiles-wordpress-media-library-folders-cloud'),
				'title_continue_sync' 					=> esc_html__('Do you want to continue import to library?', 'cloudfiles-wordpress-media-library-folders-cloud'),
				'title_sync' 							=> esc_html__('Import to library', 'cloudfiles-wordpress-media-library-folders-cloud'),
				'title_ok' 								=> esc_html__('Ok', 'cloudfiles-wordpress-media-library-folders-cloud'),
				'title_error' 							=> esc_html__('Error', 'cloudfiles-wordpress-media-library-folders-cloud'),
				'button_create' 						=> esc_html__('Create', 'cloudfiles-wordpress-media-library-folders-cloud'),
				'button_cancel' 						=> esc_html__('Cancel', 'cloudfiles-wordpress-media-library-folders-cloud'),
				'popup_create_folder' 					=> esc_html__('Create folder', 'cloudfiles-wordpress-media-library-folders-cloud'),
				'popup_placeholder_create_folder' 		=> esc_html__('Folder name', 'cloudfiles-wordpress-media-library-folders-cloud'),
				'popup_error_create_folder' 			=> esc_html__('Please, input folder name.', 'cloudfiles-wordpress-media-library-folders-cloud'),
				'popup_error_select_node' 				=> esc_html__('Please, select a folder.', 'cloudfiles-wordpress-media-library-folders-cloud'),
				'providers' 							=> CLOUDFILES_WORDPRESS_MEDIA_LIBRARY_FOLDERS_CLOUD_PROVIDERS,
				'context_menu_create' 					=> esc_html__('Create folder', 'cloudfiles-wordpress-media-library-folders-cloud'),
				'context_menu_rename' 					=> esc_html__('Rename folder', 'cloudfiles-wordpress-media-library-folders-cloud'),
				'context_menu_remove' 					=> esc_html__('Remove folder', 'cloudfiles-wordpress-media-library-folders-cloud'),
				'context_menu_edit' 					=> esc_html__('Edit folder', 'cloudfiles-wordpress-media-library-folders-cloud'),
				'context_menu_cut' 						=> esc_html__('Cut', 'cloudfiles-wordpress-media-library-folders-cloud'),
				'context_menu_copy' 					=> esc_html__('Copy', 'cloudfiles-wordpress-media-library-folders-cloud'),
				'context_menu_paste' 					=> esc_html__('Paste', 'cloudfiles-wordpress-media-library-folders-cloud'),
				'dragdrop'								=> esc_html__('Drag and Drop me hover a folder', 'cloudfiles-wordpress-media-library-folders-cloud'),
				'media_mode' 							=> $media_mode,
				'move_file_text' 						=> esc_html__('Moving files', 'cloudfiles-wordpress-media-library-folders-cloud'),
				'youarehere' 							=> esc_html__('You are here', 'cloudfiles-wordpress-media-library-folders-cloud'),
				'home' 									=> esc_html__('Home', 'cloudfiles-wordpress-media-library-folders-cloud'),
				'order_folder_label'    				=> esc_html__('Sort folder', 'cloudfiles-wordpress-media-library-folders-cloud'),
				'order_img_label'       				=> esc_html__('Sort media', 'cloudfiles-wordpress-media-library-folders-cloud'),
				'zip'       							=> esc_html__('Zip & archives', 'cloudfiles-wordpress-media-library-folders-cloud'),
				'pdf'       							=> esc_html__('PDF', 'cloudfiles-wordpress-media-library-folders-cloud'),
				'other'       							=> esc_html__('Other', 'cloudfiles-wordpress-media-library-folders-cloud'),
				'date'       							=> esc_html__('Date', 'cloudfiles-wordpress-media-library-folders-cloud'),
				'lang_size'       						=> esc_html__('Size', 'cloudfiles-wordpress-media-library-folders-cloud'),
				'lang_weight'       					=> esc_html__('Weight', 'cloudfiles-wordpress-media-library-folders-cloud'),
				'clear_filters'       					=> esc_html__('Clear filters and sorting', 'cloudfiles-wordpress-media-library-folders-cloud'),
				'display_own_media'       				=> 'all',
				'sort_label'       						=> esc_html__('Sorting / Filtering', 'cloudfiles-wordpress-media-library-folders-cloud'),
				'media_type'       						=> esc_html__('Media type', 'cloudfiles-wordpress-media-library-folders-cloud'),
				'document_embedder_title'       		=> esc_html__('Cloudfiles - Document Embedder', 'cloudfiles-wordpress-media-library-folders-cloud'),
				'document_embedder_click'       		=> esc_html__('Click here to Open Media Library to select document', 'cloudfiles-wordpress-media-library-folders-cloud'),
				'document_title'       					=> esc_html__('Document', 'cloudfiles-wordpress-media-library-folders-cloud'),
				'change_wh_title'       				=> esc_html__('Change the Height & Width of the document', 'cloudfiles-wordpress-media-library-folders-cloud'),
				'max_pixels_title'       				=> esc_html__('Ex: 500px or 100%', 'cloudfiles-wordpress-media-library-folders-cloud'),
				'change_w_title'       					=> esc_html__('Width', 'cloudfiles-wordpress-media-library-folders-cloud'),
				'change_h_title'       					=> esc_html__('Height', 'cloudfiles-wordpress-media-library-folders-cloud'),
				'upload_successfully_title'       		=> esc_html__('Upload successfully.', 'cloudfiles-wordpress-media-library-folders-cloud'),
				'media_url'       						=> esc_url( admin_url( 'upload.php' ) ),
				'folders' 								=> $term_list,
				'is_upload_page' 						=> ($pagenow === 'upload.php') ? 1 : 0,
				'copy_to_clipboard' 					=> esc_html__('Redirect URL has been copied.', 'cloudfiles-wordpress-media-library-folders-cloud'),
			) );
		}
	}


	/**
	 * Add menu item.
	 *
	 * @since    1.0.0
	 */
	public function admin_menu() {
		add_menu_page( 
			esc_html__( 'WordPress Media Library Folders Cloud', 'cloudfiles-wordpress-media-library-folders-cloud' ),
			esc_html__( 'Media Library Folders Cloud', 'cloudfiles-wordpress-media-library-folders-cloud' ), 
			'edit_theme_options', 
			'cloudfiles_wordpress_media_library_folders_cloud', 
			array($this, 'admin_menu_callback'), 
			'dashicons-cloud',
			11
		);
	}


	/**
	 * Menu item callback.
	 *
	 * @since    1.0.0
	 */
	public function admin_menu_callback(){
		Cloudfiles_Wordpress_Media_Library_Folders_Cloud_Admin_Settings::output();
	}

	public function admin_media_manager($hook){
		require_once plugin_dir_path( dirname( __FILE__ ) ) . 'admin/partials/media/manager.php';
		require_once plugin_dir_path( dirname( __FILE__ ) ) . 'admin/partials/media/file-upload.php';
	}
	
	/**
     * Display or retrieve the HTML dropdown list of categories.
     *
     * @return void
     */
    public function add_folder_filter()
    {
        // phpcs:disable WordPress.Security.NonceVerification.Recommended -- No action, nonce is not required
        global $pagenow;
        if ($pagenow === 'upload.php') {

			foreach (CLOUDFILES_WORDPRESS_MEDIA_LIBRARY_FOLDERS_CLOUD_TANONOMIES as $tax) {
				$p = str_replace('noucloudfiles_tax_', '', $tax);
				$p = ($p == 'onedrive_b') ? CLOUDFILES_WORDPRESS_MEDIA_LIBRARY_FOLDERS_CLOUD_ONEDRIVE_BUSINESS : $p;
				$provider = new Cloudfiles_Wordpress_Media_Library_Folders_Cloud_Pro($p);
				if($provider->is_enable()){
					$term_label  = sprintf('%s %s', esc_html__('Folder', 'cloudfiles-wordpress-media-library-folders-cloud'), $provider->client->get_name());
					$selected = isset($_GET['noucloudfiles_'. $p .'_folder']) ? $_GET['noucloudfiles_'. $p .'_folder'] : 0;
					$dropdown_options = array(
						'show_option_none'  => $term_label,
						'hide_empty'        => false,
						'hierarchical'      => true,
						'orderby'           => 'name',
						'taxonomy'          => $tax,
						'name'              => 'noucloudfiles_'. $p .'_folder',
						'id'                => $p.'-media-category',
						'selected'          => (int) $selected
					);
					wp_dropdown_categories($dropdown_options);
				}
			}
        }
        // phpcs:enable
	}

	/**
	 * Get list folder
	 *
	 * @param $provider
	 *
	 * @return bool|mixed|WP_Error
	 */
	public function init_list_folder($provider){
		try {
			$data = $provider->get_folder_cloud('', true, true);
		} catch (\Throwable $th) {
			error_log($th->getMessage());
		}
	}

	public function created_cloud_folder($provider, $args, $term){
		try {
			$provider->get_folder_cloud('', true, true);
		} catch (\Throwable $th) {
			error_log($th->getMessage());
		}

		if($provider->slug != CLOUDFILES_WORDPRESS_MEDIA_LIBRARY_FOLDERS_CLOUD_LOCAL){
			$folder = noucloudfiles_get_folder_by_path($provider->slug, $args['path']);
			if($folder){
				update_term_meta($term["term_id"], 'noucloudfiles_folder_id', $folder['id']);
				update_term_meta($term["term_id"], 'noucloudfiles_folder_info', $folder);
			}
		}
	}

	public function post_plupload_upload_ui()
	{
		noucloudfiles_dropdown_folder_media();
	}

	/**
     * Set file to current folder after upload files
     *
     * @param integer $attachment_id Id of attachment
     *
     * @return void
     */
    public function after_upload($attachment_id)
    {
		// Get the parent folder from the post request
        // phpcs:ignore WordPress.Security.NonceVerification.Missing -- No action, nonce is not required
        if(empty($_POST['noucloudfiles_provider'])){
			return;
		}

		$provider = $_POST['noucloudfiles_provider'];

		if (isset($_POST['noucloudfiles_folder'])) {
            // phpcs:ignore WordPress.Security.NonceVerification.Missing -- No action, nonce is not required
            $parent = (int) $_POST['noucloudfiles_folder'];
        } else {
            $parent = 0;
		}
		
		switch ($provider) {
			case CLOUDFILES_WORDPRESS_MEDIA_LIBRARY_FOLDERS_CLOUD_GOOGLE_DRIVE:
				$taxonomy = CLOUDFILES_WORDPRESS_MEDIA_LIBRARY_FOLDERS_CLOUD_GOOGLE_DRIVE_TANONOMY_NAME;
				break;
			case CLOUDFILES_WORDPRESS_MEDIA_LIBRARY_FOLDERS_CLOUD_DROPBOX:
				$taxonomy = CLOUDFILES_WORDPRESS_MEDIA_LIBRARY_FOLDERS_CLOUD_DROPBOX_TANONOMY_NAME;
				break;
			case CLOUDFILES_WORDPRESS_MEDIA_LIBRARY_FOLDERS_CLOUD_ONEDRIVE:
				$taxonomy = CLOUDFILES_WORDPRESS_MEDIA_LIBRARY_FOLDERS_CLOUD_ONEDRIVE_TANONOMY_NAME;
				break;
			case CLOUDFILES_WORDPRESS_MEDIA_LIBRARY_FOLDERS_CLOUD_ONEDRIVE_BUSINESS:
				$taxonomy = CLOUDFILES_WORDPRESS_MEDIA_LIBRARY_FOLDERS_CLOUD_ONEDRIVE_BUSINESS_TANONOMY_NAME;
				break;
			case CLOUDFILES_WORDPRESS_MEDIA_LIBRARY_FOLDERS_CLOUD_AWS:
				$taxonomy = CLOUDFILES_WORDPRESS_MEDIA_LIBRARY_FOLDERS_CLOUD_AWS_TANONOMY_NAME;
				break;
			default:
				$taxonomy = CLOUDFILES_WORDPRESS_MEDIA_LIBRARY_FOLDERS_CLOUD_TANONOMY_NAME;
				break;
		}
		
		$post_upload = get_post($attachment_id);

        // only set object to term when upload files from media library screen
        if (!empty($post_upload)) {
            if ($parent) {
                wp_set_object_terms($attachment_id, $parent, $taxonomy, true);

                /**
                 * Set attachmnent folder after upload
                 *
                 * @param integer Attachment ID
                 * @param integer Target folder
                 * @param array   Extra informations
                 *
                 * @ignore Hook already documented
                 */
				$data = [
					'trigger' => 'upload',
					'provider' => $provider,
					'taxonomy' => $taxonomy,
					'term_id' => $parent
				];

                do_action('noucloudfiles_attachment_set_folder', $attachment_id, $parent, $data);
            }
        }
	}

	public function copy_file_local_to_cloud($attachment_id, $term_id, $data){
		if(empty($data['provider'])){
			return false;
		}

		if($data['provider'] == CLOUDFILES_WORDPRESS_MEDIA_LIBRARY_FOLDERS_CLOUD_LOCAL){
			return false;
		}

		update_post_meta( $attachment_id, 'noucloudfiles_attachment_set_folder', $data );

		if($data['trigger'] == 'upload'){
			$file = get_attached_file( $attachment_id, true );
			// Remove corrupted meta
			delete_post_meta( $attachment_id, '_wp_attachment_metadata' );

			require_once ABSPATH . '/wp-admin/includes/image.php';
			// Generate new attachment meta
			wp_update_attachment_metadata( $attachment_id, wp_generate_attachment_metadata( $attachment_id, $file ) );
		}

		noucloudfiles_upload_file_to_cloud( $data['provider'], $attachment_id, $data['term_id'] );
	}

	/**
	 * Filters the link query arguments.
	 *
	 * @since 1.0.0
	 *
	 * @param array $query An array of WP_Query arguments.
	 *
	 * @return array
	 */
	function elementor_pre_get_posts( $query ) {

		if(!empty($_REQUEST['action'])){
			if ( 'query-attachments' === $_REQUEST['action'] ) {
				if (isset($_REQUEST['query']['post_mime_type'])) {
					$query->query_vars['post_mime_type'] = '';
				}
			}
		}

		return $query;
	}
}
