<?php
/**
 * Settings Page/Tab
 *
 * @link       https://themeforest.net/user/nouthemes/portfolio
 * @since      1.0.0
 *
 * @package    Cloudfiles_Wordpress_Media_Library_Folders_Cloud
 * @subpackage Cloudfiles_Wordpress_Media_Library_Folders_Cloud/admin
 */

if ( ! defined( 'ABSPATH' ) ) {
	exit; // Exit if accessed directly
}

if ( ! class_exists( 'Cloudfiles_Wordpress_Media_Library_Folders_Cloud_Admin_Settings_Page', false ) ) :

	/**
	 * Cloudfiles_Wordpress_Media_Library_Folders_Cloud_Admin_Settings_Page.
	 */
	abstract class Cloudfiles_Wordpress_Media_Library_Folders_Cloud_Admin_Settings_Page {

		/**
		 * The ID of this plugin.
		 *
		 * @since    1.0.0
		 * @access   private
		 * @var      string    $plugin_name    The ID of this plugin.
		 */
		protected $plugin_name;

		/**
		 * The version of this plugin.
		 *
		 * @since    1.0.0
		 * @access   private
		 * @var      string    $version    The current version of this plugin.
		 */
		protected $version;

		/**
		 * Setting page id.
		 *
		 * @var string
		 */
		protected $id = '';

		/**
		 * Setting page label.
		 *
		 * @var string
		 */
		protected $label = '';

		/**
		 * Button submit label.
		 *
		 * @var string
		 */
		protected $button_label = '';

		protected $active = 0;
		protected $redirect_url;

		/**
		 * Constructor.
		 */
		public function __construct() {
			$this->plugin_name = 'Cloudfiles - WordPress Media Library Folders Cloud';
			$this->version = CLOUDFILES_WORDPRESS_MEDIA_LIBRARY_FOLDERS_CLOUD_VERSION;

			add_filter( 'noucloudfiles_settings_tabs_array', array( $this, 'add_settings_page' ), 20 );
			add_action( 'noucloudfiles_sections_' . $this->id, array( $this, 'output_sections' ) );
			add_action( 'noucloudfiles_settings_' . $this->id, array( $this, 'output' ) );
			add_action( 'noucloudfiles_settings_save_' . $this->id, array( $this, 'save' ) );

			$GLOBALS['cloudfiles_hide_save_button'] = false;
			$GLOBALS['cloudfiles_hide_active_button'] = true;
			$GLOBALS['cloudfiles_hide_deactive_button'] = true;

			$this->button_label = esc_html__( 'Save changes', 'cloudfiles-wordpress-media-library-folders-cloud' );
			$this->active = get_option('nou_cloudfiles_wordpress_media_license_active', 0);
		}

		/**
		 * Get settings page ID.
		 *
		 * @since 3.0.0
		 * @return string
		 */
		public function get_id() {
			return $this->id;
		}

		/**
		 * Get settings page label.
		 *
		 * @since 3.0.0
		 * @return string
		 */
		public function get_label() {
			return $this->label;
		}

		/**
		 * Add this page to settings.
		 *
		 * @param array $pages
		 *
		 * @return mixed
		 */
		public function add_settings_page( $pages ) {
			$pages[ $this->id ] = $this->label;

			return $pages;
		}

		/**
		 * Get settings array.
		 *
		 * @return array
		 */
		public function get_settings() {
			return apply_filters( 'noucloudfiles_get_settings_' . $this->id, array() );
		}

		/**
		 * Get sections.
		 *
		 * @return array
		 */
		public function get_sections() {
			return apply_filters( 'noucloudfiles_get_sections_' . $this->id, array() );
		}

		/**
		 * Output sections.
		 */
		public function output_sections() {
			global $noucloudfiles_current_section;

			$sections = $this->get_sections();

			if ( empty( $sections ) || 1 === sizeof( $sections ) ) {
				return;
			}

			echo '<ul class="subsubsub">';

			$array_keys = array_keys( $sections );

			foreach ( $sections as $id => $label ) {
				echo '<li><a href="' . admin_url( 'admin.php?page=cloudfiles_wordpress_media_library_folders_cloud&tab=' . $this->id . '&section=' . sanitize_title( $id ) ) . '" class="' . ( $noucloudfiles_current_section == $id ? 'current' : '' ) . '">' . $label . '</a> ' . ( end( $array_keys ) == $id ? '' : '|' ) . ' </li>';
			}

			echo '</ul><br class="clear" />';
		}

		/**
		 * Output the settings.
		 */
		public function output() {
			$settings = $this->get_settings();

			Cloudfiles_Wordpress_Media_Library_Folders_Cloud_Admin_Settings::output_fields( $settings );
		}

		/**
		 * Save settings.
		 */
		public function save() {
			global $noucloudfiles_current_section;

			$settings = $this->get_settings();
			Cloudfiles_Wordpress_Media_Library_Folders_Cloud_Admin_Settings::save_fields( $settings );

			if ( $noucloudfiles_current_section ) {
				do_action( 'noucloudfiles_update_options_' . $this->id . '_' . $noucloudfiles_current_section );
			}
		}
	}

endif;
