<?php
/**
 * Woocommerce Settings
 *
 * @link       https://themeforest.net/user/nouthemes/portfolio
 * @since      1.0.0
 *
 * @package    Cloudfiles_Wordpress_Media_Library_Folders_Cloud
 * @subpackage Cloudfiles_Wordpress_Media_Library_Folders_Cloud/admin
 */

defined( 'ABSPATH' ) || exit;

class Cloudfiles_Wordpress_Media_Library_Folders_Cloud_Admin_Setting_Woocommerce extends Cloudfiles_Wordpress_Media_Library_Folders_Cloud_Admin_Settings_Page {

	/**
	 * Constructor.
	 */
	public function __construct() {
		$this->id    = 'woocommerce';
		$this->label = esc_html__( 'Woocommerce', 'cloudfiles-wordpress-media-library-folders-cloud' );

		parent::__construct();
	}

	/**
	 * Get settings array.
	 *
	 * @return array
	 */
	public function get_settings() {

		$settings = apply_filters(
			'noucloudfiles_woocommerce_settings',
			array(
				array(
					'title' => esc_html__( 'Woocommerce', 'cloudfiles-wordpress-media-library-folders-cloud' ),
					'type'  => 'title',
					'desc'  => '',
					'id'    => 'woocommerce_section',
				),
				array(
					'title' => esc_html__( 'Enable folder woocommerce', 'cloudfiles-wordpress-media-library-folders-cloud' ),
					'type'  => 'checkbox',
					'desc'  => '',
					'id'    => 'noucloudfiles_enable_woocommerce',
					'desc_tip' => false,
				),

				array(
					'type' => 'sectionend',
					'id'   => 'woocommerce_section',
				),

			)
		);

		return apply_filters( 'noucloudfiles_get_settings_' . $this->id, $settings );
	}

	/**
	 * Output the settings.
	 */
	public function output() {
		$settings = $this->get_settings();
		Cloudfiles_Wordpress_Media_Library_Folders_Cloud_Admin_Settings::output_fields( $settings );
	}

	/**
	 * Save settings.
	 */
	public function save() {
		$settings = $this->get_settings();
        Cloudfiles_Wordpress_Media_Library_Folders_Cloud_Admin_Settings::save_fields( $settings );
        
        $enbale = get_option('noucloudfiles_enable_woocommerce');
        if($enbale == 'yes'){
            Cloudfiles_Wordpress_Media_Library_Folders_Cloud_Woocommerce::clone_category_to_folder();
        }
	}
}
