<?php
/**
 * Onedrive Settings
 *
 * @link       https://themeforest.net/user/nouthemes/portfolio
 * @since      1.0.0
 *
 * @package    Cloudfiles_Wordpress_Media_Library_Folders_Cloud
 * @subpackage Cloudfiles_Wordpress_Media_Library_Folders_Cloud/admin
 */

defined( 'ABSPATH' ) || exit;

class Cloudfiles_Wordpress_Media_Library_Folders_Cloud_Admin_Setting_Onedrive_Business extends Cloudfiles_Wordpress_Media_Library_Folders_Cloud_Admin_Settings_Page {

	/**
	 * Constructor.
	 */
	public function __construct() {
		$this->id    = CLOUDFILES_WORDPRESS_MEDIA_LIBRARY_FOLDERS_CLOUD_ONEDRIVE_BUSINESS;
		$this->label = esc_html__( 'Onedrive Business', 'cloudfiles-wordpress-media-library-folders-cloud' );

		parent::__construct();

		add_action('noucloudfiles_after_submit_'.$this->id, array( $this, 'html_authorize'));
	}

	public function html_authorize(){
		$client_id = get_option('onedrive_business_client_id');
		$client_secret = get_option('onedrive_business_client_secret');
		if(!empty($client_id) && !empty($client_secret)):
		?>
		<button name="authorize" class="uk-button uk-button-primary noucloudfiles-authorize-button" type="button" value="<?php echo esc_attr($this->id);?>"><?php echo esc_html__( 'Authorize account', 'cloudfiles-wordpress-media-library-folders-cloud' ); ?></button>
		<?php
		endif;
	}

	/**
	 * Get settings array.
	 *
	 * @return array
	 */
	public function get_settings() {

        $value = get_option('noucloudfiles_enable_onedrive_business', 'yes');
        $erasure_text = sprintf( '<a href="%s" target="_blank">%s</a>', esc_url( 'https://go.microsoft.com/fwlink/?linkid=2094263' ), esc_html__('Learn more about redirect URIs and the restrictions', 'cloudfiles-wordpress-media-library-folders-cloud') );
		$settings = apply_filters(
			'noucloudfiles_onedrive_business_settings',
			array(
				array(
					'title' => esc_html__( 'Onedrive Business API Client', 'cloudfiles-wordpress-media-library-folders-cloud' ),
					'type'  => 'title',
					'desc'  => '',
					'id'    => 'onedrive_business_section',
				),
				array(
					'title' => esc_html__( 'Enable', 'cloudfiles-wordpress-media-library-folders-cloud' ),
					'type'  => 'checkbox',
					'value'  => $value,
					'id'    => 'noucloudfiles_enable_onedrive_business',
					'desc_tip' => false,
				),
				array(
					'title' => esc_html__( 'Client ID', 'cloudfiles-wordpress-media-library-folders-cloud' ),
					'type'  => 'text',
					'desc'  => '',
					'id'    => 'onedrive_business_client_id',
					'class' => 'client_id',
					'desc_tip' => false,
				),
				array(
					'title' => esc_html__( 'Client Secret', 'cloudfiles-wordpress-media-library-folders-cloud' ),
					'type'  => 'password',
					'desc'  => '',
					'id'    => 'onedrive_business_client_secret',
					'class' => 'client_secret',
					'desc_tip' => false,
				),
				array(
					'title' => esc_html__( 'Authorize redirect url', 'cloudfiles-wordpress-media-library-folders-cloud' ),
					'type'  => 'url',
					'readonly' => true,
					'desc'  => $erasure_text,
					'value' => admin_url('upload.php'),
					'default' => admin_url('upload.php'),
					'id'    => 'onedrive_business_redirect_url',
					'desc_tip' => false,
				),
				array(
					'type' => 'sectionend',
					'id'   => 'onedrive_business_section',
				),

			)
		);

		return apply_filters( 'noucloudfiles_get_settings_' . $this->id, $settings );
	}

	/**
	 * Output the settings.
	 */
	public function output() {
		$settings = $this->get_settings();
		Cloudfiles_Wordpress_Media_Library_Folders_Cloud_Admin_Settings::output_fields( $settings );
	}

	/**
	 * Save settings.
	 */
	public function save() {
		$settings = $this->get_settings();
		Cloudfiles_Wordpress_Media_Library_Folders_Cloud_Admin_Settings::save_fields( $settings );

		$provider = new Cloudfiles_Wordpress_Media_Library_Folders_Cloud_Pro($this->id);
		if($provider->is_enable()){
			$provider->get_folder_cloud('', true, true);
		}
	}
}
