<?php
/**
 * General Settings
 *
 * @link       https://themeforest.net/user/nouthemes/portfolio
 * @since      1.0.0
 *
 * @package    Cloudfiles_Wordpress_Media_Library_Folders_Cloud
 * @subpackage Cloudfiles_Wordpress_Media_Library_Folders_Cloud/admin
 */

defined( 'ABSPATH' ) || exit;

class Cloudfiles_Wordpress_Media_Library_Folders_Cloud_Admin_Setting_General extends Cloudfiles_Wordpress_Media_Library_Folders_Cloud_Admin_Settings_Page {

	/**
	 * Constructor.
	 */
	public function __construct() {
		$this->id    = 'general';
		$this->label = esc_html__( 'License', 'cloudfiles-wordpress-media-library-folders-cloud' );
		parent::__construct();
	}

	/**
	 * Get settings array.
	 *
	 * @return array
	 */
	public function get_settings() {
		
		if($this->active == 0){
			$settings = apply_filters(
				'noucloudfiles_general_settings',
				array(
					array(
						'title' => esc_html__( 'In order to receive all benefits of WordPress Media Library Folders Cloud, you need to activate your plugin.', 'cloudfiles-wordpress-media-library-folders-cloud' ),
						'type'  => 'title',
						'desc'  => '',
						'id'    => 'store_address',
					),
					array(
						'title' => esc_html__( 'Your email address', 'cloudfiles-wordpress-media-library-folders-cloud' ),
						'type'  => 'email',
						'id'    => 'nou_cloudfiles_wordpress_media_license_email',
						'desc_tip' => false,
					),
					array(
						'title' => esc_html__( 'Your purchase key', 'cloudfiles-wordpress-media-library-folders-cloud' ),
						'type'  => 'password',
						'id'    => 'nou_cloudfiles_wordpress_media_license_key',
						'desc_tip' => false,
					),
					array(
						'type' => 'sectionend',
						'id'   => 'store_address',
					),

				)
			);
		}else{
			$settings = apply_filters(
				'noucloudfiles_general_settings',
				array(
					array(
						'title' => esc_html__( 'You have activated WordPress Media Library Folders Cloud version which allows you to access all the customer benefits. Thank you for choosing WordPress Media Library Folders Cloud.', 'cloudfiles-wordpress-media-library-folders-cloud' ),
						'type'  => 'title',
						'desc'  => '',
						'id'    => 'store_address',
					),
					array(
						'type' => 'sectionend',
						'id'   => 'store_address',
					),
	
				)
			);
		}

		return apply_filters( 'noucloudfiles_get_settings_' . $this->id, $settings );
	}

	/**
	 * Output the settings.
	 */
	public function output() {
		$GLOBALS['cloudfiles_hide_save_button'] = true;

		if($this->active == 0){
			$GLOBALS['cloudfiles_hide_active_button'] = false;
		}else{
			$GLOBALS['cloudfiles_hide_active_button'] = true;
			$GLOBALS['cloudfiles_hide_deactive_button'] = false;
		}
		
		$settings = $this->get_settings();
		Cloudfiles_Wordpress_Media_Library_Folders_Cloud_Admin_Settings::output_fields( $settings );
	}

	/**
	 * Save settings.
	 */
	public function save() {
		$settings = $this->get_settings();
		Cloudfiles_Wordpress_Media_Library_Folders_Cloud_Admin_Settings::save_fields( $settings );
		if($this->active == 0){
			$this->activate_license();
		}else{
			$this->deactivate_license();
		}

		wp_redirect(admin_url('admin.php?page=cloudfiles_wordpress_media_library_folders_cloud'));
		exit;
	}

	public function activate_license(){
		if ( is_admin() ) {
		    $error = '';
		    $message = '';
		    $licenser = new Cloudfiles_Wordpress_Media_Library_Folders_Cloud_Licenser(CLOUDFILES_WORDPRESS_MEDIA_LIBRARY_FOLDERS_CLOUD_DIR_FILE, $this->plugin_name, $this->version );
		    $licenser->active_plugin($error, $message);
		}    
	}

	public function deactivate_license(){
		if ( is_admin() ) {
		    $licenser = new Cloudfiles_Wordpress_Media_Library_Folders_Cloud_Licenser(CLOUDFILES_WORDPRESS_MEDIA_LIBRARY_FOLDERS_CLOUD_DIR_FILE, $this->plugin_name, $this->version );
		    $licenser->deactivate();
		}    
	}
}
