<?php
/**
 * Dropbox Settings
 *
 * @link       https://themeforest.net/user/nouthemes/portfolio
 * @since      1.0.0
 *
 * @package    Cloudfiles_Wordpress_Media_Library_Folders_Cloud
 * @subpackage Cloudfiles_Wordpress_Media_Library_Folders_Cloud/admin
 */

defined( 'ABSPATH' ) || exit;

class Cloudfiles_Wordpress_Media_Library_Folders_Cloud_Admin_Setting_Dropbox extends Cloudfiles_Wordpress_Media_Library_Folders_Cloud_Admin_Settings_Page {

	/**
	 * Constructor.
	 */
	public function __construct() {
		$this->id    = CLOUDFILES_WORDPRESS_MEDIA_LIBRARY_FOLDERS_CLOUD_DROPBOX;
		$this->label = esc_html__( 'Dropbox', 'cloudfiles-wordpress-media-library-folders-cloud' );

		parent::__construct();
	}

	/**
	 * Get settings array.
	 *
	 * @return array
	 */
	public function get_settings() {
		$value = get_option('noucloudfiles_enable_dropbox', 'yes');
		$settings = apply_filters(
			'noucloudfiles_dropbox_settings',
			array(
				array(
					'title' => esc_html__( 'Dropbox API Client', 'cloudfiles-wordpress-media-library-folders-cloud' ),
					'type'  => 'title',
					'desc'  => '',
					'id'    => 'dropbox_section',
				),
				array(
					'title' => esc_html__( 'Enable', 'cloudfiles-wordpress-media-library-folders-cloud' ),
					'type'  => 'checkbox',
					'value'  => $value,
					'id'    => 'noucloudfiles_enable_dropbox',
					'desc_tip' => false,
				),
				array(
					'title' => esc_html__( 'Access token', 'cloudfiles-wordpress-media-library-folders-cloud' ),
					'type'  => 'password',
					'desc'  => '',
					'id'    => 'dropbox_access_token',
					'desc_tip' => false,
				),

				array(
					'type' => 'sectionend',
					'id'   => 'dropbox_section',
				),

			)
		);

		return apply_filters( 'noucloudfiles_get_settings_' . $this->id, $settings );
	}

	/**
	 * Output the settings.
	 */
	public function output() {
		$settings = $this->get_settings();
		Cloudfiles_Wordpress_Media_Library_Folders_Cloud_Admin_Settings::output_fields( $settings );
	}

	/**
	 * Save settings.
	 */
	public function save() {
		$settings = $this->get_settings();
		Cloudfiles_Wordpress_Media_Library_Folders_Cloud_Admin_Settings::save_fields( $settings );

		$provider = new Cloudfiles_Wordpress_Media_Library_Folders_Cloud_Pro($this->id);
		if($provider->is_enable()){
			$provider->get_folder_cloud();
		}
	}
}
