<?php
/**
 * Template for displaying course meta students within the loop.
 *
 * @author        ThemeMove
 * @theme-since   2.4.0
 * @theme-version 2.7.9
 */

defined( 'ABSPATH' ) || exit();

$course = learn_press_get_course();
if ( ! $course || '1' !== Maxcoach::setting( 'course_archive_meta_student_enable' ) ) {
	return;
}

$count = $course->get_users_enrolled();
?>
<div class="course-students">
	<span class="meta-icon far fa-user-alt"></span>
	<span class="meta-value">
		<?php echo esc_html( sprintf( _n( '%s Student', '%s Students', $count, 'maxcoach' ), number_format_i18n( $count ) ) ); ?>
	</span>
</div>
