<?php
/**
 * Template for displaying course meta quiz within the loop.
 *
 * @author        ThemeMove
 * @theme-since   2.7.9
 * @theme-version 2.7.9
 */

defined( 'ABSPATH' ) || exit();

$course = learn_press_get_course();

if ( ! $course || '1' !== Maxcoach::setting( 'course_archive_meta_quiz_enable' ) ) {
	return;
}

$count_items = intval( $course->count_items( 'lp_quiz' ) );
?>
<div class="course-quiz">
	<span class="meta-icon far fa-puzzle-piece"></span>
	<span class="meta-value">
		<?php
		echo esc_html( sprintf( _n( '%s Quiz', '%s Quizzes', $count_items, 'maxcoach' ), number_format_i18n( $count_items ) ) );
		?>
	</span>
</div>
