<?php
/**
 * Template for displaying course rate.
 *
 * This template can be overridden by copying it to maxcoach/learnpress/addons/course-review/course-rate.php.
 *
 * @author        ThimPress
 * @package       LearnPress/Course-Review/Templates
 * @version       3.0.2
 *
 * @theme-since   2.7.9
 * @theme-version 2.7.9
 */

// Prevent loading this file directly
defined( 'ABSPATH' ) || exit;

if ( ! isset( $course_rate_res ) ) {
	return;
}

$rated = $course_rate_res['rated'] ?? 0;
$total = $course_rate_res['total'] ?? 0;
?>
<div class="course-rating">
	<h3 class="course-review-heading"><?php esc_html_e( 'Reviews', 'maxcoach' ); ?></h3>

	<div class="course-rating-content">
		<div class="average-rating" itemprop="aggregateRating" itemscope=""
		     itemtype="http://schema.org/AggregateRating">
			<p class="rating-title secondary-color"><?php esc_html_e( 'Average Rating', 'maxcoach' ); ?></p>

			<div class="rating-box">
				<div class="average-value primary-color"
				     itemprop="ratingValue">
					<?php echo ( $rated ) ? esc_html( number_format( (float) $rated, 2, '.', '' ) ) : 0; ?>
				</div>
				<div class="review-star">
					<?php
					LP_Addon_Course_Review_Preload::$addon->get_template( 'rating-stars.php', [ 'rated' => $rated ] );
					?>
				</div>
				<div class="review-amount" itemprop="ratingCount">
					<?php printf( _n( '<span>%d</span> rating', '<span>%d</span> ratings', $total, 'maxcoach' ), $total ); ?>
				</div>
			</div>
		</div>

		<div class="detailed-rating">
			<p class="rating-title secondary-color"><?php esc_html_e( 'Detailed Rating', 'maxcoach' ); ?></p>

			<div class="rating-box">
				<?php
				if ( isset( $course_rate_res['items'] ) && ! empty( $course_rate_res['items'] ) ):
					foreach ( $course_rate_res['items'] as $item ):
						$css_percent = $item['percent'] . '%';
						?>
						<div class="rating-rated-item">
							<div class="rating-point">
								<?php Maxcoach_Templates::render_rating( $item['rated'] ); ?>
							</div>
							<div class="rating-progress maxcoach-progress style-02">
								<div class="single-progress-bar">
									<div class="progress-bar-wrap">
										<div class="progress-bar"
										     style="width: <?php echo esc_attr( $css_percent ); ?>">
										</div>
									</div>
								</div>
							</div>
							<div class="rating-count"><?php echo esc_html( $item['total'] ); ?></div>
						</div>
					<?php
					endforeach;
				endif;
				?>
			</div>
		</div>
	</div>
</div>
