<?php
defined( 'ABSPATH' ) || exit;

/**
 * Plugin installation and activation for WordPress themes
 */
if ( ! class_exists( 'Maxcoach_Register_Plugins' ) ) {
	class Maxcoach_Register_Plugins {

		public function __construct() {
			add_filter( 'insight_core_tgm_plugins', [ $this, 'register_required_plugins' ] );
		}

		public function register_required_plugins( $plugins ) {
			/*
			 * Array of plugin arrays. Required keys are name and slug.
			 * If the source is NOT from the .org repo, then source is also required.
			 */
			$new_plugins = array(
				array(
					'name'     => esc_html__( 'Insight Core', 'maxcoach' ),
					'slug'     => 'insight-core',
					'source'   => 'https://www.dropbox.com/scl/fi/zn7u6igqmycybagfje2he/insight-core-2.6.5.zip?rlkey=7t4urvc2is33v9nddm3xiw68x&dl=1',
					'version'  => '2.6.5',
					'required' => true,
				),
				array(
					'name'     => esc_html__( 'Elementor', 'maxcoach' ),
					'slug'     => 'elementor',
					'required' => true,
				),
				array(
					'name'        => 'ThemeMove Addons For Elementor',
					'description' => 'Additional functions for Elementor',
					'slug'        => 'tm-addons-for-elementor',
					'logo'        => 'insight',
					'source'      => 'https://www.dropbox.com/scl/fi/sljs4b1itrspuqe6romfx/tm-addons-for-elementor-1.3.2.zip?rlkey=75n9q9pvpv952d5b2dz5ibhue&dl=1',
					'version'     => '1.3.2',
				),
				array(
					'name'    => esc_html__( 'Revolution Slider', 'maxcoach' ),
					'slug'    => 'revslider',
					'source'  => 'https://www.dropbox.com/scl/fi/lz7cx897upiqupa7mhcu5/revslider-6.6.20.zip?rlkey=n9r1ect3oomio05gi722j01cm&dl=1',
					'version' => '6.6.20',
				),
				array(
					'name' => esc_html__( 'LearnPress – WordPress LMS Plugin', 'maxcoach' ),
					'slug' => 'learnpress',
				),
				array(
					'name' => esc_html__( 'LearnPress – Course Review', 'maxcoach' ),
					'slug' => 'learnpress-course-review',
				),
				array(
					'name'    => esc_html__( 'ThemeMove Payment Add-ons for LearnPress', 'maxcoach' ),
					'slug'    => 'thememove-payment',
					'source'  => 'https://www.dropbox.com/s/0lkgm1x08m76uv6/thememove-payment-addon-for-learnpress-1.2.0.zip?dl=1',
					'version' => '1.2.0',
				),
				array(
					'name' => esc_html__( 'Paid Memberships Pro', 'maxcoach' ),
					'slug' => 'paid-memberships-pro',
				),
				array(
					'name'    => esc_html__( 'LearnPress - Paid Membership Pro Integration', 'maxcoach' ),
					'slug'    => 'learnpress-paid-membership-pro',
					'source'  => 'https://www.dropbox.com/s/vb8ylua8egmnplr/learnpress-paid-membership-pro-4.0.1.1.zip?dl=1',
					'version' => '4.0.1.1',
				),
				array(
					'name' => esc_html__( 'WP Events Manager', 'maxcoach' ),
					'slug' => 'wp-events-manager',
				),
				array(
					'name' => esc_html__( 'Video Conferencing with Zoom', 'maxcoach' ),
					'slug' => 'video-conferencing-with-zoom-api',
				),
				array(
					'name'     => esc_html__( 'Taxonomy Thumbnail', 'maxcoach' ),
					'slug'     => 'sf-taxonomy-thumbnail',
					'required' => true,
				),
				array(
					'name' => esc_html__( 'Contact Form 7', 'maxcoach' ),
					'slug' => 'contact-form-7',
				),
				array(
					'name' => esc_html__( 'MailChimp for WordPress', 'maxcoach' ),
					'slug' => 'mailchimp-for-wp',
				),
				array(
					'name' => esc_html__( 'WooCommerce', 'maxcoach' ),
					'slug' => 'woocommerce',
				),
				array(
					'name' => esc_html__( 'WPC Smart Compare for WooCommerce', 'maxcoach' ),
					'slug' => 'woo-smart-compare',
				),
				array(
					'name' => esc_html__( 'WPC Smart Wishlist for WooCommerce', 'maxcoach' ),
					'slug' => 'woo-smart-wishlist',
				),
				array(
					'name' => esc_html__( 'WP-PostViews', 'maxcoach' ),
					'slug' => 'wp-postviews',
				),
				array(
					'name'    => esc_html__( 'Instagram Feed', 'maxcoach' ),
					'slug'    => 'elfsight-instagram-feed-cc',
					'source'  => 'https://www.dropbox.com/s/o55sjvh8fs2nmoq/elfsight-instagram-feed-cc-4.0.3.zip?dl=1',
					'version' => '4.0.3',
				),
			);

			return array_merge( $plugins, $new_plugins );
		}
	}

	new Maxcoach_Register_Plugins();
}
